/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.command;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.chatcommandlog.ChatCommandLogService;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.command.CommandSpyService;
import com.equestricraft.mod.player.OnlinePlayer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class CommandListener {
    @Service
    private static ChatCommandLogService chatCommandLogService;
    @Service
    private static CommandSpyService commandSpyService;
    private static final OnlinePlayerCache onlinePlayerCache;

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        try {
            ServerPlayer serverPlayer = ((CommandSourceStack)event.getParseResults().getContext().getSource()).m_81375_();
            OnlinePlayer player = onlinePlayerCache.requirePlayer(serverPlayer.m_142081_()).require(OnlinePlayer.class);
            String string = event.getParseResults().getReader().getString();
            chatCommandLogService.logCommand(player.getId(), string);
            commandSpyService.broadcastForCommandSpy(player, string);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }

    private CommandListener() {
    }

    static {
        onlinePlayerCache = OnlinePlayerCache.getInstance();
    }
}

