/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.command;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Permission;
import com.equestricraft.mod.command.argproviders.ArgumentSuggestionProvider;
import com.equestricraft.mod.context.Context;
import com.equestricraft.mod.permission.PermissionService;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class CommandRegistration {
    @Service
    private static PermissionService permissionService;
    private static final OnlinePlayerCache onlinePlayerCache;
    private static final Log log;

    @SubscribeEvent
    public static void onRegisterCommandEvent(RegisterCommandsEvent event) {
        CommandRegistration.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        List<Class<?>> classes = ReflectionHelper.scanClassesAnnotatedWith(Command.class);
        for (Class<?> clazz : classes) {
            Command[] commandAnnotations;
            for (Command commandAnnotation : commandAnnotations = (Command[])clazz.getAnnotationsByType(Command.class)) {
                LiteralArgumentBuilder<CommandSourceStack> command = CommandRegistration.registerCommandClass(clazz, commandAnnotation);
                dispatcher.register(command);
            }
        }
    }

    private static LiteralArgumentBuilder<CommandSourceStack> registerCommandClass(Class<?> clazz, Command command) {
        Object commandInstance = Services.getService(clazz);
        Permission permission = clazz.getAnnotation(Permission.class);
        String[] topLevelCommandSignature = command.value().toLowerCase().split(" ");
        LiteralArgumentBuilder head = null;
        for (int i = topLevelCommandSignature.length - 1; i >= 0; --i) {
            String s = topLevelCommandSignature[i];
            LiteralArgumentBuilder newCommand = Commands.m_82127_((String)s);
            if (permission != null) {
                newCommand = (LiteralArgumentBuilder)newCommand.requires(c -> {
                    try {
                        ServerPlayer onlinePlayer = c.m_81375_();
                        return permissionService.doesPlayerHavePermission(onlinePlayer, permission.value());
                    }
                    catch (CommandSyntaxException ex) {
                        log.error("Error checking command permission", ex);
                        return false;
                    }
                });
            }
            if (head == null) {
                for (Method method : clazz.getDeclaredMethods()) {
                    Command[] methodAnnotations;
                    for (Command methodAnnotation : methodAnnotations = (Command[])method.getAnnotationsByType(Command.class)) {
                        ArgumentBuilder<CommandSourceStack, ?> subCommand = CommandRegistration.registerCommandMethod(commandInstance, (LiteralArgumentBuilder<CommandSourceStack>)newCommand, method, methodAnnotation);
                        if (subCommand == null) continue;
                        newCommand.then(subCommand);
                    }
                }
            } else {
                newCommand.then(head);
            }
            head = newCommand;
        }
        if (head == null) {
            throw new IllegalArgumentException("No top level command provided");
        }
        return head;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerCommandMethod(Object commandInstance, LiteralArgumentBuilder<CommandSourceStack> topLevel, Method method, Command subCommand) {
        LiteralArgumentBuilder lastLiteral;
        Permission subPermission = method.getAnnotation(Permission.class);
        boolean runInAsync = method.isAnnotationPresent(Async.class);
        if (subCommand == null) {
            return null;
        }
        String[] subLevelCommandSignature = subCommand.value().toLowerCase().split(" ");
        LiteralArgumentBuilder subLevel = null;
        for (String s : subLevelCommandSignature) {
            if (s.isEmpty()) continue;
            LiteralArgumentBuilder newCommand = Commands.m_82127_((String)s);
            if (subPermission != null) {
                newCommand = (LiteralArgumentBuilder)newCommand.requires(c -> {
                    try {
                        ServerPlayer onlinePlayer = c.m_81375_();
                        return permissionService.doesPlayerHavePermission(onlinePlayer, subPermission.value());
                    }
                    catch (CommandSyntaxException ex) {
                        log.error("Error checking command permission", ex);
                        return false;
                    }
                });
            }
            if (subLevel != null) {
                subLevel.then((ArgumentBuilder)newCommand);
            }
            subLevel = newCommand;
        }
        LinkedList<ParamInfo> paramInfoList = new LinkedList<ParamInfo>();
        List<RequiredArgumentBuilder<CommandSourceStack, ?>> argsList = CommandRegistration.buildArgumentsList(method, paramInfoList);
        LiteralArgumentBuilder literalArgumentBuilder = lastLiteral = subLevel != null ? subLevel : topLevel;
        if (ListUtils.isNotEmpty(argsList)) {
            RequiredArgumentBuilder head = null;
            for (int i = argsList.size() - 1; i >= 0; --i) {
                RequiredArgumentBuilder argumentBuilder = argsList.get(i);
                if (head == null) {
                    argumentBuilder = (RequiredArgumentBuilder)argumentBuilder.executes(cs -> {
                        Object[] paramArray = new Object[paramInfoList.size()];
                        int count = 0;
                        for (ParamInfo paramInfo : paramInfoList) {
                            Object argument = cs.getArgument(paramInfo.name(), paramInfo.type());
                            paramArray[count++] = argument;
                        }
                        return CommandRegistration.executeMethod(commandInstance, method, (CommandContext<CommandSourceStack>)cs, runInAsync, paramArray);
                    });
                } else {
                    argumentBuilder.then(head);
                }
                head = argumentBuilder;
            }
            if (subLevel != null) {
                return subLevel.then(head);
            }
            return head;
        }
        return lastLiteral.executes(cs -> CommandRegistration.executeMethod(commandInstance, method, (CommandContext<CommandSourceStack>)cs, runInAsync, new Object[0]));
    }

    private static int executeMethod(Object commandInstance, Method method, CommandContext<CommandSourceStack> cs, boolean runInAsync, Object[] paramArray) {
        try {
            if (!CommandRegistration.hasPermissionToExecute(method, ((CommandSourceStack)cs.getSource()).m_81375_())) {
                ((CommandSourceStack)cs.getSource()).m_81352_((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("permission.has-no-permission")));
                return 0;
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        Runnable runnable2 = () -> {
            try {
                CommandRegistration.setContext(cs);
                Object ret = method.invoke(commandInstance, paramArray);
                CommandRegistration.handleResponseObject(ret, (CommandSourceStack)cs.getSource());
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                ((CommandSourceStack)cs.getSource()).m_81352_((Component)CommandRegistration.buildTextComponent(targetException.getMessage()));
                log.error(targetException.getMessage(), targetException);
            }
            catch (IllegalAccessException ex) {
                log.error("Error running command", ex);
            }
            catch (CommandSyntaxException ex) {
                log.error("Command syntax error", ex);
            }
            finally {
                Context.clearContext();
            }
        };
        if (runInAsync) {
            TaskScheduler.executeAsyncTask(runnable2);
        } else {
            runnable2.run();
        }
        return 0;
    }

    private static boolean hasPermissionToExecute(Method method, ServerPlayer player) {
        return CommandRegistration.hasPermission(method, player) && CommandRegistration.hasPermission(method.getDeclaringClass(), player);
    }

    private static boolean hasPermission(AnnotatedElement annotatedElement, ServerPlayer player) {
        if (annotatedElement.isAnnotationPresent(Permission.class)) {
            Permission permission = annotatedElement.getAnnotation(Permission.class);
            return permissionService.doesPlayerHavePermission(player, permission.value());
        }
        return true;
    }

    private static void handleResponseObject(Object responseObject, CommandSourceStack source2) throws CommandSyntaxException {
        if (responseObject == null) {
            return;
        }
        if (responseObject instanceof String) {
            String stringResponse = (String)responseObject;
            source2.m_81354_((Component)CommandRegistration.buildTextComponent(stringResponse), true);
        } else if (responseObject instanceof Response) {
            Response response = (Response)responseObject;
            ECPlayer onlinePlayer = onlinePlayerCache.requirePlayer(source2.m_81375_().m_142081_());
            onlinePlayer.showResponse(response);
        }
    }

    private static TextComponent buildTextComponent(String message) {
        return new TextComponent(message);
    }

    private static void setContext(CommandContext<CommandSourceStack> cs) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)cs.getSource()).m_81375_();
        Context.setContext(player);
    }

    private static List<RequiredArgumentBuilder<CommandSourceStack, ?>> buildArgumentsList(Method method, List<ParamInfo> paramInfoList) {
        LinkedList argsList = new LinkedList();
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isAnnotationPresent(Arg.class)) {
                throw new IllegalArgumentException("All arguments must have the @Arg annotation");
            }
            Arg arg = parameter.getAnnotation(Arg.class);
            String argName = arg.name().isEmpty() ? parameter.getName() : arg.name();
            ArgumentType<?> argumentType = CommandRegistration.getArgumentType(parameter);
            ArgumentSuggestionProvider instance = CommandRegistration.getArgumentSuggestionsInstance(arg.suggestionProvider());
            RequiredArgumentBuilder c = Commands.m_82129_((String)argName, argumentType).suggests((context, builder) -> {
                try {
                    CommandRegistration.setContext((CommandContext<CommandSourceStack>)context);
                    ECPlayer player = onlinePlayerCache.requirePlayer(((CommandSourceStack)context.getSource()).m_81375_().m_142081_());
                    for (String value : instance.buildArgumentList(player)) {
                        builder.suggest(value);
                    }
                    CompletableFuture completableFuture = builder.buildFuture();
                    return completableFuture;
                }
                finally {
                    Context.clearContext();
                }
            });
            paramInfoList.add(new ParamInfo(argName, parameter.getType()));
            argsList.add(c);
        }
        return argsList;
    }

    private static <T extends ArgumentSuggestionProvider> T getArgumentSuggestionsInstance(Class<? extends T> clazz) {
        return (T)((ArgumentSuggestionProvider)Services.getService(clazz));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArgumentType<?> getArgumentType(Parameter parameter) {
        if (!parameter.isAnnotationPresent(Arg.class)) throw new IllegalArgumentException("All command method parameters must have the @Arg annotation");
        Arg arg = parameter.getAnnotation(Arg.class);
        if (parameter.getType() == String.class) {
            if (!arg.restOfString()) return StringArgumentType.string();
            return StringArgumentType.greedyString();
        }
        if (parameter.getType() == Integer.class) return IntegerArgumentType.integer();
        if (parameter.getType() == Integer.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (parameter.getType() == Double.class) return DoubleArgumentType.doubleArg();
        if (parameter.getType() == Double.TYPE) {
            return DoubleArgumentType.doubleArg();
        }
        if (parameter.getType() == Float.class) return FloatArgumentType.floatArg();
        if (parameter.getType() == Float.TYPE) {
            return FloatArgumentType.floatArg();
        }
        if (parameter.getType() == Long.class) return LongArgumentType.longArg();
        if (parameter.getType() != Long.TYPE) throw new IllegalArgumentException("Invalid parameter type");
        return LongArgumentType.longArg();
    }

    private CommandRegistration() {
    }

    static {
        onlinePlayerCache = OnlinePlayerCache.getInstance();
        log = Log.getLogger(CommandRegistration.class.getName());
    }

    record ParamInfo(String name, Class<?> type) {
    }
}

