/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.command;

import com.equestricraft.common.command.CommandExecutionResponse;
import com.equestricraft.core.system.SubSystem;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.command.CommandExecutor;
import com.equestricraft.redis.RedisRequestReceiver;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

public class CommandSystem
implements SubSystem {
    private final RedisRequestReceiver<String, CommandExecutionResponse> commandSubmitChannel = new RedisRequestReceiver("forge_command_dispatcher");
    private static final Log log = Log.getLogger(CommandSystem.class.getName());

    @Override
    public void onEnable() {
        this.commandSubmitChannel.registerListener(c -> {
            try {
                CommandExecutor.executeCommand(c);
                return CommandExecutionResponse.success();
            }
            catch (CommandSyntaxException ex) {
                log.error("Error executing command", ex);
                return CommandExecutionResponse.fail(ex.getMessage());
            }
        });
    }
}

