/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.context;

import com.equestricraft.base.response.Response;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.player.PlayerContext;
import com.equestricraft.logging.Log;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;

public class Context {
    private static final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();
    private static final Log log = Log.getLogger(Context.class.getName());

    public static void setContext(ServerPlayer serverPlayer) {
        ECPlayer player = onlinePlayerCache.requirePlayer(serverPlayer.m_142081_());
        Context.setContext(player);
    }

    public static void setContext(ECPlayer player) {
        PlayerContext.set(player);
    }

    public static void clearContext() {
        PlayerContext.clear();
    }

    public static void wrapInContext(ECPlayer player, Runnable action) {
        Context.wrapInContext(player, () -> {
            action.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void wrapInContext(ECPlayer player, Supplier<T> action) {
        Context.setContext(player);
        try {
            T responseObject = action.get();
            if (responseObject == null) {
                return;
            }
            if (responseObject instanceof String) {
                String stringResponse = (String)responseObject;
                player.sendMessage(stringResponse);
            } else if (responseObject instanceof Response) {
                Response response = (Response)responseObject;
                player.showResponse(response);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            player.sendMessage(ex.getMessage());
        }
        finally {
            Context.clearContext();
        }
    }

    private Context() {
    }
}

