/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.coordinate;

import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import net.minecraft.network.FriendlyByteBuf;

public class CoordinateSerializer {
    public static void serializeCoordinate(Coordinate coordinate, FriendlyByteBuf buffer) {
        buffer.writeDouble(coordinate.x());
        buffer.writeDouble(coordinate.y());
        buffer.writeDouble(coordinate.z());
        buffer.m_130070_(coordinate.world());
    }

    public static Coordinate deserializeCoordinate(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        String world = buffer.m_130277_();
        return new Coordinate(x, y, z, world);
    }

    public static void serializeDirectionalCoordinate(DirectionalCoordinate coordinate, FriendlyByteBuf buffer) {
        buffer.writeDouble(coordinate.x());
        buffer.writeDouble(coordinate.y());
        buffer.writeDouble(coordinate.z());
        buffer.m_130070_(coordinate.world());
        buffer.writeFloat(coordinate.rotationY());
        buffer.writeFloat(coordinate.rotationX());
    }

    public static DirectionalCoordinate deserializeDirectionalCoordinate(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        String world = buffer.m_130277_();
        float rotY = buffer.readFloat();
        float rotX = buffer.readFloat();
        return new DirectionalCoordinate(x, y, z, world, rotY, rotX);
    }

    public static void serializeBlockCoordinate(BlockCoordinate coordinate, FriendlyByteBuf buffer) {
        buffer.writeInt(coordinate.x());
        buffer.writeInt(coordinate.y());
        buffer.writeInt(coordinate.z());
        buffer.m_130070_(coordinate.world());
    }

    public static BlockCoordinate deserializeBlockCoordinate(FriendlyByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        String world = buffer.m_130277_();
        return new BlockCoordinate(x, y, z, world);
    }

    private CoordinateSerializer() {
    }
}

