/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.dev;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.player.nickname.Nickname;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Permission;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.dev.DevCommandService;
import com.equestricraft.mod.horse.entity.HorseEntitySession;
import com.equestricraft.mod.npc.NPCSession;
import com.equestricraft.mod.prompt.PlayerSearchPrompt;
import com.equestricraft.mod.weather.WeatherUpdateSession;

@Command(value="dev")
@Permission(value="equestricraft.dev")
public class DevCommand {
    @Service
    private DevCommandService devCommandService;
    @Service
    private NPCSession npcSession;
    @Service
    private HorseEntitySession horseEntitySession;
    @Service
    private WeatherUpdateSession weatherUpdateSession;

    @Async
    @Command(value="error-test")
    public Response errorTest(@Arg(name="message") String message) {
        return this.devCommandService.errorTest(message);
    }

    @Async
    @Command(value="show-title")
    public Response showTitle(@Arg(name="text") String test) {
        return this.devCommandService.showTitle(test);
    }

    @Async
    @Command(value="message")
    public void showMessage(@Arg(restOfString=true) String text) {
        ModPlayerContext.getPlayer().getAlert().info("Test", text);
    }

    @Async
    @Command(value="search-players")
    public Response searchPlayers() {
        return PlayerSearchPrompt.showPlayerSearchPrompt(ModPlayerContext.getPlayer()).map(player -> ResponseFactory.success(player.getIgn())).orElseGet(ResponseFactory::fail);
    }

    @Async
    @Command(value="confirm")
    public Response confirm() {
        ConfirmResponse response = ModPlayerContext.getPlayer().getConfirmation().confirm("Confirm?", "Yes or no?");
        return ResponseFactory.success("" + response.getValue());
    }

    @Command(value="refresh-npcs")
    public Response npcDespawn() {
        this.npcSession.refreshAllNPCs();
        return ResponseFactory.success();
    }

    @Command(value="despawn-horses")
    public Response horseDespawn() {
        this.horseEntitySession.despawnAllHorses();
        return ResponseFactory.success();
    }

    @Async
    @Command(value="update-weather")
    public Response updateWeather() {
        this.weatherUpdateSession.updateWeather();
        return ResponseFactory.success();
    }

    @Command(value="nickname-test")
    public void nicknameTest(@Arg String string) {
        Nickname nickname = Nickname.createNickname(string);
        ModPlayerContext.getOnlinePlayer().sendMessage(nickname.getTextItem());
    }
}

