/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.discord;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.social.SocialSettings;
import com.equestricraft.discord.DiscordMessageChannel;
import com.equestricraft.discord.verification.DiscordVerificationCompleter;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Permission;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.packet.ClientBoundOpenUrlPacket;
import com.equestricraft.mod.player.OnlinePlayer;

@Command(value="discord")
public class DiscordCommand {
    private final DiscordMessageChannel discordMessageChannel = new DiscordMessageChannel();
    private final DiscordVerificationCompleter discordVerificationCompleter = new DiscordVerificationCompleter();

    @Async
    @Command
    public Response onCommand() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        String discordInviteUrl = SocialSettings.getDiscordServer();
        ClientBoundOpenUrlPacket packet = new ClientBoundOpenUrlPacket(discordInviteUrl);
        player.sendPacket(packet);
        return ResponseFactory.success(discordInviteUrl);
    }

    @Async
    @Command(value="verify")
    public Response onVerify(@Arg(name="code") String code) {
        ECPlayer player = ModPlayerContext.getPlayer();
        boolean success = this.discordVerificationCompleter.completeVerification(player.getId(), code);
        if (success) {
            return ResponseFactory.success(I18n.getLabel("discord.verification-successful"));
        }
        return ResponseFactory.fail(I18n.getLabel("discord.verification.fail.prompt.title"), I18n.getLabel("discord.verification-code-not-recognised"));
    }

    @Async
    @Command(value="announcement")
    @Permission(value="equestricraft.discord.announcement")
    public Response onAnnouncement(@Arg(name="text", restOfString=true) String text) {
        this.discordMessageChannel.postInAnnouncementChannel(text, new Object[0]);
        return ResponseFactory.success("discord.announcement-posted");
    }
}

