/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.discoverlocation;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.discoverlocation.DiscoverLocation;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.discoverlocation.CurrentLocationInfo;
import com.equestricraft.core.player.discoverlocation.LocationMoveResponse;
import com.equestricraft.core.player.discoverlocation.PlayerDiscoverLocationSession;
import com.equestricraft.mod.discoverlocation.DiscoverLocationService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;

public class DiscoverLocationServiceImpl
implements DiscoverLocationService {
    @Service
    private PlayerDiscoverLocationSession playerDiscoverLocationSession;

    @Override
    public void processLocationMove(OnlinePlayer player, double x, double y, double z) {
        if (player.getDiscoverLocations().getMillisSinceLastLocationCheck() <= 1000L) {
            return;
        }
        LocationMoveResponse response = this.playerDiscoverLocationSession.processLocationMove(x, y, z, player.getECLevel(), player);
        this.processNewDiscoveries(player, response.locationsDiscovered());
        List<DiscoverLocation> currentLocation = player.getDiscoverLocations().getCurrentLocation().getLocations();
        List<DiscoverLocation> newLocations = response.locations();
        if (this.areLocationsDifferent(currentLocation, newLocations)) {
            CurrentLocationInfo newLocationInfo = new CurrentLocationInfo(newLocations);
            String address = newLocationInfo.getAddressString().orElse(null);
            player.getDisplay().getLocation().setText(address);
            player.getDiscoverLocations().setCurrentLocation(newLocationInfo);
        }
        player.getDiscoverLocations().setLocationCheckPerformed();
    }

    private void processNewDiscoveries(ECPlayer player, List<DiscoverLocation> newLocations) {
        if (!newLocations.isEmpty()) {
            boolean compendiumUpdate = false;
            for (DiscoverLocation location : newLocations) {
                if (location.isAnnounceDiscovery()) {
                    player.sendTitle(location.getName(), location.getXpReward() > 0 ? location.getXpReward() + "xp" : null);
                }
                if (!location.isShowInCompendium()) continue;
                compendiumUpdate = true;
            }
            if (compendiumUpdate) {
                player.sendToast(I18n.getLabel("compendium.updated"));
            }
        }
    }

    private boolean areLocationsDifferent(List<DiscoverLocation> currentLocations, List<DiscoverLocation> newLocations) {
        if (currentLocations.size() != newLocations.size()) {
            return true;
        }
        for (int i = 0; i < currentLocations.size(); ++i) {
            DiscoverLocation loc2;
            DiscoverLocation loc1 = currentLocations.get(i);
            if (loc1.equals(loc2 = newLocations.get(i))) continue;
            return true;
        }
        return false;
    }
}

