/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.economy;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.BankAccountType;
import com.equestricraft.core.economy.account.BankAccountInfo;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.mod.economy.BankAccountPage;
import com.equestricraft.mod.economy.BankAccountPageService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Comparator;
import java.util.List;

public class BankAccountPageServiceImpl
extends Pagination<BankAccountInfo, BankAccountPage, Object, Object>
implements BankAccountPageService {
    @Service
    private BankAccountSession bankAccountSession;
    private static final int MAXIMUM_PER_PAGE = 3;

    @Override
    public BankAccountPage retrieveBankAccountPage(OnlinePlayer player, int pageNumber) {
        List<BankAccountInfo> bankAccounts = this.bankAccountSession.getAllPlayersBankAccounts(player);
        return (BankAccountPage)this.paginate(bankAccounts, pageNumber, SortDirection.ASCENDING, null, null);
    }

    @Override
    protected int getMaximumPerPage() {
        return 3;
    }

    @Override
    protected boolean filter(BankAccountInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<BankAccountInfo> compare(Object sortOrderObject) {
        return this.mainAtStartComparator().thenComparing(BankAccountInfo::accountName);
    }

    private Comparator<BankAccountInfo> mainAtStartComparator() {
        return (o1, o2) -> {
            if (o1.type() == BankAccountType.MAIN) {
                return -1;
            }
            if (o2.type() == BankAccountType.MAIN) {
                return 1;
            }
            return 0;
        };
    }

    @Override
    protected BankAccountPage buildPage(List<BankAccountInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new BankAccountPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

