/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.economy;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.economy.transaction.BankAccountTransactionInfo;
import com.equestricraft.core.economy.transaction.BankAccountTransactionSession;
import com.equestricraft.mod.economy.BankAccountTransactionPage;
import com.equestricraft.mod.economy.BankAccountTransactionPageService;
import com.equestricraft.mod.economy.BankAccountTransactionSortOrder;
import java.util.Comparator;
import java.util.List;

public class BankAccountTransactionPageServiceImpl
extends Pagination<BankAccountTransactionInfo, BankAccountTransactionPage, BankAccountTransactionSortOrder, String>
implements BankAccountTransactionPageService {
    @Service
    private BankAccountTransactionSession bankAccountTransactionSession;
    private static final int MAXIMUM_PER_PAGE = 12;

    @Override
    public BankAccountTransactionPage retrieveBankAccountTransactionPage(int accountId, int pageNumber, SortDirection sortDirection, BankAccountTransactionSortOrder sortOrder, String text) {
        List<BankAccountTransactionInfo> transactions = this.bankAccountTransactionSession.getAllAccountsTransactions(accountId);
        return (BankAccountTransactionPage)this.paginate(transactions, pageNumber, sortDirection, sortOrder, text);
    }

    @Override
    protected int getMaximumPerPage() {
        return 12;
    }

    @Override
    protected boolean filter(BankAccountTransactionInfo item, String filterObject) {
        filterObject = filterObject.trim().toLowerCase();
        return item.reason().toLowerCase().contains(filterObject) || item.otherAccountName() != null && item.otherAccountName().toLowerCase().contains(filterObject) || item.otherPlayer() != null && item.otherPlayer().ign().toLowerCase().contains(filterObject);
    }

    @Override
    protected Comparator<BankAccountTransactionInfo> compare(BankAccountTransactionSortOrder sortOrderObject) {
        return switch (sortOrderObject) {
            default -> throw new IncompatibleClassChangeError();
            case BankAccountTransactionSortOrder.TIME_STAMP -> Comparator.comparing(BankAccountTransactionInfo::timeStamp);
            case BankAccountTransactionSortOrder.VALUE -> Comparator.comparing(BankAccountTransactionInfo::amount);
        };
    }

    @Override
    protected BankAccountTransactionPage buildPage(List<BankAccountTransactionInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, BankAccountTransactionSortOrder sortObject, String filterObject) {
        return new BankAccountTransactionPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

