/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.economy;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.DualAccountEconomyResponse;
import com.equestricraft.core.economy.Economy;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.account.AccountNameAlreadyUsedException;
import com.equestricraft.core.economy.account.BankAccount;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.mod.economy.BankAccountPage;
import com.equestricraft.mod.economy.BankAccountPageService;
import com.equestricraft.mod.economy.BankAccountTransactionPage;
import com.equestricraft.mod.economy.BankAccountTransactionPageService;
import com.equestricraft.mod.economy.BankAccountTransactionSortOrder;
import com.equestricraft.mod.economy.BankService;
import com.equestricraft.mod.packet.ClientBoundBankAccountTransactionListOpenPacket;
import com.equestricraft.mod.packet.ClientBoundBankAccountsListOpenPacket;
import com.equestricraft.mod.packet.ClientBoundBankMainMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.TextInputPrompt;
import com.equestricraft.mod.prompt.TransactionDetails;
import com.equestricraft.mod.prompt.TransactionDetailsEnterPrompt;
import java.util.Optional;

public class BankServiceImpl
implements BankService {
    @Service
    private Economy economy;
    @Service
    private BankAccountPageService bankAccountPageService;
    @Service
    private BankAccountTransactionPageService bankAccountTransactionPageService;
    @Service
    private BankAccountSession bankAccountSession;

    @Override
    public void showBankMainMenuToPlayer(OnlinePlayer player) {
        double mainAccountBalance = player.getEconomy().getBalance();
        ClientBoundBankMainMenuOpenPacket packet = new ClientBoundBankMainMenuOpenPacket(EconomyUtilities.formatCurrency(mainAccountBalance));
        player.sendPacket(packet);
    }

    @Override
    public void showBankAccountsMenuToPlayer(OnlinePlayer player, int pageNumber) {
        BankAccountPage page = this.bankAccountPageService.retrieveBankAccountPage(player, pageNumber);
        ClientBoundBankAccountsListOpenPacket packet = new ClientBoundBankAccountsListOpenPacket(page);
        player.sendPacket(packet);
    }

    @Override
    public void showBankAccountTransactionsMenuToPlayer(OnlinePlayer player, int accountId, int pageNumber, SortDirection sortDirection, BankAccountTransactionSortOrder sortOrder, String text) {
        BankAccountTransactionPage page = this.bankAccountTransactionPageService.retrieveBankAccountTransactionPage(accountId, pageNumber, sortDirection, sortOrder, text);
        BankAccount account = this.bankAccountSession.getAccountById(accountId);
        ClientBoundBankAccountTransactionListOpenPacket packet = new ClientBoundBankAccountTransactionListOpenPacket(accountId, account.getName(), page);
        player.sendPacket(packet);
    }

    @Override
    public Response createSavingsAccount(OnlinePlayer player) {
        Optional<String> name = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("bank.create-savings-account.enter-name.prompt.title"), I18n.getLabel("bank.create-savings-account.enter-name.prompt.message"));
        if (name.isPresent()) {
            try {
                BankAccount newAccount = this.bankAccountSession.createSavingsAccount(player, name.get());
                return ResponseFactory.success(I18n.getLabel("bank.create-savings-account.success.prompt.title"), I18n.getLabel("bank.create-savings-account.success.prompt.message", newAccount.getName()));
            }
            catch (AccountNameAlreadyUsedException ex) {
                return ResponseFactory.fail(I18n.getLabel("bank.create-savings-account.fail.prompt.title"), ex);
            }
        }
        return ResponseFactory.fail();
    }

    @Override
    public Response renameAccount(OnlinePlayer player, int accountId) {
        BankAccount account = this.bankAccountSession.getAccountById(accountId);
        String oldName = account.getName();
        Optional<String> newName = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("bank.rename-account.enter-new-name.prompt.title"), I18n.getLabel("bank.rename-account.enter-new-name.prompt.message"));
        if (newName.isPresent()) {
            try {
                this.bankAccountSession.renameAccount(account, newName.get());
                return ResponseFactory.success(I18n.getLabel("bank.rename-account.success.prompt.title"), I18n.getLabel("bank.rename-account.success.prompt.message", oldName, account.getName()));
            }
            catch (EconomyException ex) {
                return ResponseFactory.fail(I18n.getLabel("bank.rename-account.fail.prompt.title"), ex);
            }
        }
        return ResponseFactory.fail();
    }

    @Override
    public Response depositIntoAccount(OnlinePlayer player, int accountId) {
        BankAccount targetAccount = this.bankAccountSession.getAccountById(accountId);
        BankAccount mainAccount = this.bankAccountSession.getPlayersMainAccount(player);
        Optional<TransactionDetails> details = TransactionDetailsEnterPrompt.showTransactionDetailsPrompt(player, I18n.getLabel("bank.deposit-into-savings.message", targetAccount.getName()));
        if (details.isPresent()) {
            try {
                DualAccountEconomyResponse response = this.economy.transfer(mainAccount, targetAccount, details.get().amount(), details.get().reason());
                return ResponseFactory.success(I18n.getLabel("bank.deposit-into-savings.success.prompt.title"), I18n.getLabel("bank.deposit-into-savings.success.prompt.message", response.fromAccountBalanceFormatted(), targetAccount.getName(), response.toAccountBalanceFormatted()));
            }
            catch (EconomyException ex) {
                return ResponseFactory.fail(I18n.getLabel("bank.deposit-into-savings.fail.prompt.title"), ex);
            }
        }
        return ResponseFactory.fail();
    }

    @Override
    public Response withdrawFromAccount(OnlinePlayer player, int accountId) {
        BankAccount sourceAccount = this.bankAccountSession.getAccountById(accountId);
        BankAccount mainAccount = this.bankAccountSession.getPlayersMainAccount(player);
        Optional<TransactionDetails> details = TransactionDetailsEnterPrompt.showTransactionDetailsPrompt(player, I18n.getLabel("bank.withdraw-from-savings.message", sourceAccount.getName()));
        if (details.isPresent()) {
            try {
                DualAccountEconomyResponse response = this.economy.transfer(sourceAccount, mainAccount, details.get().amount(), details.get().reason());
                return ResponseFactory.success(I18n.getLabel("bank.withdraw-from-savings.success.prompt.title"), I18n.getLabel("bank.withdraw-from-savings.success.prompt.message", response.toAccountBalanceFormatted(), sourceAccount.getName(), response.fromAccountBalanceFormatted()));
            }
            catch (EconomyException ex) {
                return ResponseFactory.fail(I18n.getLabel("bank.withdraw-from-savings.fail.prompt.title"), ex);
            }
        }
        return ResponseFactory.fail();
    }
}

