/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.entitlement;

import com.equestricraft.common.version.BuildInformation;
import com.equestricraft.core.http.SimpleHttp;
import com.equestricraft.logging.Log;
import java.io.IOException;
import net.minecraft.world.entity.player.Player;

public class EntitlementCheck {
    private static final EntitlementCheck instance = new EntitlementCheck();
    private final SimpleHttp simpleHttp = SimpleHttp.getInstance();
    private static final Log log = Log.getLogger(EntitlementCheck.class.getName());

    public static EntitlementCheck getInstance() {
        return instance;
    }

    private EntitlementCheck() {
    }

    public boolean isPlayerEntitled(Player player) {
        if (!BuildInformation.get().isEntitlementCheckEnabled()) {
            return true;
        }
        log.info("Checking entitlement for " + player.m_7755_().m_6111_());
        try {
            return this.simpleHttp.getBoolean(this.getApiUrl() + "/entitlement?playerUuid=" + player.m_142081_() + "&groupIdentifiers=" + this.getGroupsCsv());
        }
        catch (IOException ex) {
            log.warn("Could not connect to entitlement server", (Object)ex.getMessage());
            return true;
        }
    }

    private String getApiUrl() {
        return BuildInformation.get().getEntitlementBaseUrl() + "/api";
    }

    private String getGroupsCsv() {
        String groups2 = BuildInformation.get().getEntitlementGroups();
        if (groups2 == null) {
            return "";
        }
        return groups2;
    }
}

