/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.entitlement;

import com.equestricraft.logging.Log;
import com.equestricraft.mod.entitlement.EntitlementCheck;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class ServerEntitlementListener {
    private static final EntitlementCheck entitlementCheck = EntitlementCheck.getInstance();
    private static final Log log = Log.getLogger(ServerEntitlementListener.class.getName());

    @SubscribeEvent
    public static void checkEntitlement(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer serverPlayer = (ServerPlayer)event.getPlayer();
        boolean entitled = entitlementCheck.isPlayerEntitled((Player)serverPlayer);
        if (!entitled) {
            log.warn("A player tried to join the server who is not on the entitlement list: {}", (Object)serverPlayer.m_7755_().m_6111_());
            serverPlayer.f_8906_.m_9942_((Component)new TextComponent("You are using a build of the EquestriCraft Mod which you are not allowed to use. Your client will stop in a moment"));
        }
    }

    private ServerEntitlementListener() {
    }
}

