/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.fasttravel;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.fasttravel.group.FastTravelGroup;
import com.equestricraft.core.fasttravel.group.FastTravelGroupRepository;
import com.equestricraft.core.fasttravel.point.FastTravelPoint;
import com.equestricraft.core.fasttravel.point.FastTravelPointRepository;
import com.equestricraft.mod.fasttravel.FastTravelService;
import com.equestricraft.mod.npc.NPCInteractEvent;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class FastTravelListener {
    @Service
    private static FastTravelService fastTravelService;
    @Service
    private static FastTravelPointRepository fastTravelPointRepository;
    @Service
    private static FastTravelGroupRepository fastTravelGroupRepository;

    @SubscribeEvent
    public static void onNpcInteract(NPCInteractEvent event) {
        Optional<FastTravelPoint> point = fastTravelPointRepository.findByNpc(event.getNpc().getId());
        point.ifPresent(ftp -> {
            FastTravelGroup group = (FastTravelGroup)fastTravelGroupRepository.findByKey(ftp.getGroupId());
            if (fastTravelService.canAccess(event.getOnlinePlayer(), group)) {
                event.addAction(I18n.getLabel("npc.action.fast-travel", group.getName()), () -> fastTravelService.showFastTravelMenu(event.getOnlinePlayer(), (FastTravelPoint)ftp));
            }
        });
    }

    private FastTravelListener() {
    }
}

