/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.fasttravel;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.fasttravel.FastTravelGroupInfo;
import com.equestricraft.core.fasttravel.FastTravelPointInfo;
import com.equestricraft.core.fasttravel.FastTravelSession;
import com.equestricraft.core.fasttravel.FastTravelTransformer;
import com.equestricraft.core.fasttravel.group.FastTravelGroup;
import com.equestricraft.core.fasttravel.group.FastTravelGroupRepository;
import com.equestricraft.core.fasttravel.point.FastTravelPoint;
import com.equestricraft.core.fasttravel.point.FastTravelPointRepository;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.fasttravel.FastTravelService;
import com.equestricraft.mod.packet.ClientBoundFastTravelScreenOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.TeleportUtil;
import java.util.List;

public class FastTravelServiceImpl
implements FastTravelService {
    @Service
    private FastTravelSession fastTravelSession;
    @Service
    private FastTravelPointRepository fastTravelPointRepository;
    @Service
    private FastTravelGroupRepository fastTravelGroupRepository;
    @Service
    private FastTravelTransformer fastTravelTransformer;
    private static final Log log = Log.getLogger(FastTravelServiceImpl.class.getName());

    @Override
    public void showFastTravelMenu(OnlinePlayer player, FastTravelPoint fastTravelPoint) {
        FastTravelGroup currentGroup = (FastTravelGroup)this.fastTravelGroupRepository.findByKey(fastTravelPoint.getGroupId());
        List<FastTravelPoint> availablePoints = this.fastTravelSession.retrieveAvailablePointsForPlayer(player, fastTravelPoint);
        FastTravelGroupInfo groupInfo = this.fastTravelTransformer.toInfo(currentGroup);
        FastTravelPointInfo pointInfo = this.fastTravelTransformer.toInfo(fastTravelPoint);
        List<FastTravelPointInfo> points = this.fastTravelTransformer.toInfoList(availablePoints);
        ClientBoundFastTravelScreenOpenPacket packet = new ClientBoundFastTravelScreenOpenPacket(groupInfo, pointInfo, points);
        player.sendPacket(packet);
    }

    @Override
    public Response performFastTravel(OnlinePlayer player, int targetPointId) {
        FastTravelPoint point = (FastTravelPoint)this.fastTravelPointRepository.findByKey(targetPointId);
        FastTravelGroup group = (FastTravelGroup)this.fastTravelGroupRepository.findByKey(point.getGroupId());
        try {
            SingleAccountEconomyResponse response = player.getEconomy().withdraw(group.getCost(), group.getName() + " - " + point.getName(), "Fast Travel");
            TeleportUtil.teleportPlayer(player.serverPlayer(), point.getLocation());
            return ResponseFactory.success(I18n.getLabel("fast-travel.success", point.getName(), response.amountFormatted(), response.balanceFormatted()));
        }
        catch (EconomyException ex) {
            return ResponseFactory.fail(I18n.getLabel("fast-travel.failed.prompt.title"), ex);
        }
    }

    @Override
    public boolean canAccess(ECPlayer player, FastTravelGroup group) {
        if (group.getAccessScript().isBlank()) {
            return true;
        }
        try {
            RuleScriptResponse result = ((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(group.getAccessScript()).withPlayer(new APIPlayerDtoImpl(player.getCorePlayer()))).withGlobal(new APIGlobalDtoImpl())).withConfig(new APIConfigDtoImpl())).execute().result();
            return result.success();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing access script for group %s", group.getName()), ex);
            return false;
        }
    }
}

