/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.featureflag;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.FeatureFlagUpdateMessage;
import com.equestricraft.core.system.SubSystem;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.featureflag.FeatureFlags;
import com.equestricraft.mod.featureflag.FeatureFlagLoadService;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ClientBoundFeatureFlagUpdatePacket;
import com.equestricraft.redis.RedisChannelSubscription;
import java.util.Collections;

public class FeatureFlagSystem
implements SubSystem {
    @Service
    private FeatureFlagLoadService featureFlagLoadService;
    private final RedisChannelSubscription<FeatureFlagUpdateMessage> featureFlagUpdateMessageRedisChannelSubscription = new RedisChannelSubscription("feature-flag-update");
    private final FeatureFlags featureFlags = FeatureFlags.getInstance();

    @Override
    public void onLoad() {
        this.featureFlagLoadService.loadData();
    }

    @Override
    public void onEnable() {
        this.featureFlagUpdateMessageRedisChannelSubscription.subscribe(message -> {
            FeatureFlag flag = FeatureFlag.valueOf(message.getFlagIdentifier());
            this.featureFlags.updateFlagState(flag, message.isNewState());
            ClientBoundFeatureFlagUpdatePacket packet = new ClientBoundFeatureFlagUpdatePacket(Collections.singletonMap(flag, message.isNewState()));
            Network.sendToAll(packet);
        });
    }
}

