/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.gamemode;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Permission;
import com.equestricraft.mod.command.argproviders.OnlinePlayersArgumentSuggestionProvider;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.gamemode.GameModeService;
import com.equestricraft.mod.player.OnlinePlayer;

@Command(value="gms")
public class GameModeSurvival {
    @Service
    private GameModeService gameModeService;
    @Service
    private PlayerService playerService;

    @Async
    @Command
    @Permission(value="equestricraft.game-mode.survival")
    public Response onGameModeSurvival() {
        this.gameModeService.setSurvival(ModPlayerContext.getOnlinePlayer());
        return ResponseFactory.success(I18n.getLabel("game-mode.changed.survival"));
    }

    @Async
    @Command
    @Permission(value="equestricraft.game-mode.change-other")
    public Response onGameModeSurvival(@Arg(name="ign", suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String ign) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        this.gameModeService.setSurvival(player.require(OnlinePlayer.class));
        player.sendMessage(I18n.getLabel("game-mode.changed-by.survival"));
        return ResponseFactory.success(I18n.getLabel("game-mode.changed-other.survival", player.getIgn()));
    }
}

