/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.glow;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.glow.GlowService;
import com.equestricraft.mod.player.OnlinePlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class GlowServiceImpl
implements GlowService {
    private static final String GLOW_TEAM_NAME = "EC_GlowTeam";

    @Override
    public Response setPlayersGlow(OnlinePlayer player, String color) {
        ChatFormatting chatColor;
        if (!player.getGlow().hasAccess()) {
            return ResponseFactory.fail(I18n.getLabel("glow.no-access"));
        }
        ServerPlayer serverPlayer = player.serverPlayer();
        Scoreboard scoreboard = serverPlayer.m_36329_();
        PlayerTeam team = scoreboard.m_83489_(GLOW_TEAM_NAME);
        if (team == null) {
            team = scoreboard.m_83492_(GLOW_TEAM_NAME);
        }
        if ((chatColor = ChatFormatting.m_126657_((String)color)) == null) {
            return ResponseFactory.fail(I18n.getLabel("glow.invalid-color"));
        }
        team.m_83351_(chatColor);
        scoreboard.m_6546_(serverPlayer.m_6302_(), team);
        serverPlayer.m_146915_(true);
        return ResponseFactory.success(I18n.getLabel("glow.set.success", color));
    }

    @Override
    public Response removePlayersGlow(OnlinePlayer player) {
        ServerPlayer serverPlayer = player.serverPlayer();
        serverPlayer.m_146915_(false);
        return ResponseFactory.success(I18n.getLabel("glow.turned-off"));
    }
}

