/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.groovy.prompt;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.groovy.GroovyPromptContext;
import com.equestricraft.groovy.prompt.GroovyPromptResponse;
import com.equestricraft.groovy.prompt.request.GroovyMessagePromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyNumberInputPromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyOptionPromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyOptionPromptValue;
import com.equestricraft.groovy.prompt.request.GroovyPromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyPromptType;
import com.equestricraft.groovy.prompt.request.GroovyTextInputPromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyYesNoPromptRequest;
import com.equestricraft.mod.groovy.prompt.GroovyPromptService;
import com.equestricraft.mod.prompt.MultiSelectionOptionPrompt;
import com.equestricraft.mod.prompt.NumberInputPrompt;
import com.equestricraft.mod.prompt.OptionPromptItem;
import com.equestricraft.mod.prompt.SingleSelectionOptionPrompt;
import com.equestricraft.mod.prompt.TextInputPrompt;
import java.util.List;

public class GroovyPromptServiceImpl
implements GroovyPromptService {
    @Override
    public void processPromptRequests(ECPlayer player, GroovyPromptRequest request) {
        GroovyPromptResponse response = this.promptPlayer(player, request);
        GroovyPromptContext.setResponse(response);
    }

    private GroovyPromptResponse promptPlayer(ECPlayer player, GroovyPromptRequest request) {
        if (request instanceof GroovyMessagePromptRequest) {
            GroovyMessagePromptRequest messagePromptRequest = (GroovyMessagePromptRequest)request;
            return this.showMessagePrompt(player, messagePromptRequest);
        }
        if (request instanceof GroovyTextInputPromptRequest) {
            GroovyTextInputPromptRequest textInputPromptRequest = (GroovyTextInputPromptRequest)request;
            return this.showTextPrompt(player, textInputPromptRequest);
        }
        if (request instanceof GroovyNumberInputPromptRequest) {
            GroovyNumberInputPromptRequest numberInputPromptRequest = (GroovyNumberInputPromptRequest)request;
            return this.showNumberPrompt(player, numberInputPromptRequest);
        }
        if (request instanceof GroovyOptionPromptRequest) {
            GroovyOptionPromptRequest optionPromptRequest = (GroovyOptionPromptRequest)request;
            if (optionPromptRequest.isMultiSelection()) {
                return this.showMultiSelectionOptionPrompt(player, optionPromptRequest);
            }
            return this.showSingleSelectionOptionPrompt(player, optionPromptRequest);
        }
        if (request instanceof GroovyYesNoPromptRequest) {
            GroovyYesNoPromptRequest yesNoInputPromptRequest = (GroovyYesNoPromptRequest)request;
            return this.showYesNoPrompt(player, yesNoInputPromptRequest);
        }
        throw new IllegalArgumentException(String.format("Invalid request provided: %s", request.getClass().getName()));
    }

    private GroovyPromptResponse showMessagePrompt(ECPlayer player, GroovyMessagePromptRequest request) {
        boolean response = switch (request.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case GroovyPromptType.INFO -> player.getAlert().info(request.getTitle(), request.getMessage());
            case GroovyPromptType.ALERT -> player.getAlert().alert(request.getTitle(), request.getMessage());
            case GroovyPromptType.ERROR -> player.getAlert().error(request.getTitle(), request.getMessage());
        };
        return this.buildResponse(request, response);
    }

    private GroovyPromptResponse showTextPrompt(ECPlayer player, GroovyTextInputPromptRequest request) {
        TextInputPrompt prompt = TextInputPrompt.create().withTitle(request.getTitle()).withText(request.getMessage()).withMinimumLength(request.getMinimumLength()).withMaximumLength(request.getMaximumLength()).build();
        String value = prompt.show(player).orElse(null);
        return this.buildResponse(request, value);
    }

    private GroovyPromptResponse showNumberPrompt(ECPlayer player, GroovyNumberInputPromptRequest request) {
        NumberInputPrompt prompt = NumberInputPrompt.create().withTitle(request.getTitle()).withText(request.getMessage()).withMinimumValue(request.getMinimumValue()).withMaximumValue(request.getMaximumValue()).withDecimalPoints(request.getDecimalPoints()).build();
        Number value = prompt.show(player).orElse(null);
        return this.buildResponse(request, value);
    }

    private GroovyPromptResponse showSingleSelectionOptionPrompt(ECPlayer player, GroovyOptionPromptRequest request) {
        Integer value = SingleSelectionOptionPrompt.showOptionPrompt(player, request.getOptions(), this::buildOptionItem, request.getTitle(), request.getMessage()).map(GroovyOptionPromptValue::id).orElse(null);
        return this.buildResponse(request, value);
    }

    private GroovyPromptResponse showMultiSelectionOptionPrompt(ECPlayer player, GroovyOptionPromptRequest request) {
        List value = MultiSelectionOptionPrompt.showOptionPrompt(player, request.getOptions(), this::buildOptionItem, request.getTitle(), request.getMessage()).orElse(null);
        return this.buildResponse(request, value);
    }

    private OptionPromptItem<GroovyOptionPromptValue> buildOptionItem(final GroovyOptionPromptValue groovyOptionPromptValue) {
        return new OptionPromptItem<GroovyOptionPromptValue>(){

            @Override
            public int getId() {
                return groovyOptionPromptValue.id();
            }

            @Override
            public String getName() {
                return groovyOptionPromptValue.label();
            }

            @Override
            public String getDescription() {
                return groovyOptionPromptValue.description();
            }

            @Override
            public GroovyOptionPromptValue getItem() {
                return groovyOptionPromptValue;
            }
        };
    }

    private GroovyPromptResponse showYesNoPrompt(ECPlayer player, GroovyYesNoPromptRequest request) {
        ConfirmResponse value = player.getConfirmation().confirm(request.getTitle(), request.getMessage());
        Boolean booleanValue = switch (value.getValue()) {
            case 0 -> false;
            case 1 -> true;
            default -> null;
        };
        return this.buildResponse(request, booleanValue);
    }

    private <T> GroovyPromptResponse buildResponse(GroovyPromptRequest request, T input) {
        return new GroovyPromptResponse(request.getIdentifier(), input);
    }
}

