/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.healthmetric;

import com.equestricraft.redis.RedisSyncField;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class TPS {
    private static double currentTps = 20.0;
    private static final RedisSyncField<Double> syncedTpsField = RedisSyncField.createField("tps_value");
    private static long lastTick = 0L;

    @SubscribeEvent
    public static void onPing(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        long millisSinceLast = System.currentTimeMillis() - lastTick;
        if (millisSinceLast == 0L) {
            return;
        }
        currentTps = 1000.0f / (float)millisSinceLast;
        syncedTpsField.setValue(currentTps);
        lastTick = System.currentTimeMillis();
    }

    public static double getCurrentTps() {
        return currentTps;
    }

    private TPS() {
    }
}

