/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.client.horse.EntityHorse;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractHorseGoal
extends Goal {
    protected final EntityHorse entityHorse;
    private Long lastCanUseError = null;
    private Long lastCanContinueToUseError = null;
    private Long lastStartError = null;
    private Long lastTickError = null;
    private Long lastStopError = null;
    private static final Log log = Log.getLogger(AbstractHorseGoal.class.getName());

    protected AbstractHorseGoal(EntityHorse entityHorse) {
        this.entityHorse = entityHorse;
    }

    public final boolean m_8036_() {
        try {
            return this.hasHorseData() && this.shouldRun();
        }
        catch (Exception ex) {
            if (this.canLog(this.lastCanUseError)) {
                log.error("Error checking if a goal can be used");
                this.lastCanUseError = System.currentTimeMillis();
            }
            return false;
        }
    }

    protected abstract boolean shouldRun();

    public final boolean m_8045_() {
        try {
            return this.hasHorseData() && this.shouldContinueToUse();
        }
        catch (Exception ex) {
            if (this.canLog(this.lastCanContinueToUseError)) {
                log.error("Error checking if a goal can continue to be used");
                this.lastCanContinueToUseError = System.currentTimeMillis();
            }
            return false;
        }
    }

    protected boolean shouldContinueToUse() {
        return true;
    }

    protected boolean hasHorseData() {
        return this.entityHorse.getHorseData() != null;
    }

    public final void m_8056_() {
        block2: {
            try {
                this.startGoal();
            }
            catch (Exception ex) {
                if (!this.canLog(this.lastStartError)) break block2;
                log.error("Error starting a goal");
                this.lastStartError = System.currentTimeMillis();
            }
        }
    }

    public void startGoal() {
    }

    public final void m_8037_() {
        block2: {
            try {
                this.tickGoal();
            }
            catch (Exception ex) {
                if (!this.canLog(this.lastTickError)) break block2;
                log.error("Error ticking a goal");
                this.lastTickError = System.currentTimeMillis();
            }
        }
    }

    public void tickGoal() {
    }

    public final void m_8041_() {
        block2: {
            try {
                this.stopGoal();
            }
            catch (Exception ex) {
                if (!this.canLog(this.lastStopError)) break block2;
                log.error("Error stopping a goal");
                this.lastStopError = System.currentTimeMillis();
            }
        }
    }

    public void stopGoal() {
    }

    private boolean canLog(Long timeStamp) {
        return timeStamp == null || DateUtils.secondsSince(timeStamp) > 10;
    }
}

