/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.menus.HorseMenuService;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Commands;
import com.equestricraft.mod.command.argproviders.OnlinePlayersArgumentSuggestionProvider;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.horse.HorseNameArgumentProvider;
import com.equestricraft.mod.horse.HorseRespondToCallAction;
import com.equestricraft.mod.horse.HorseService;
import com.equestricraft.mod.horse.access.HorseAccessGrantCommand;
import com.equestricraft.mod.horse.access.HorseAccessRevokeCommand;
import com.equestricraft.mod.horse.create.HorseCreateMenuService;
import com.equestricraft.mod.horse.dead.DeathCertificateService;
import com.equestricraft.mod.horse.details.HorseDetailsUpdateService;
import com.equestricraft.mod.horse.list.HorseListService;
import com.equestricraft.mod.horse.progression.HorseProgressionService;
import com.equestricraft.mod.horse.sell.HorseSellService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@Commands(value={@Command(value="horse"), @Command(value="h")})
public class HorseCommand {
    @Service
    private HorseCreateMenuService horseCreateMenuService;
    @Service
    private HorseMenuService horseMenuService;
    @Service
    private HorseListService horseListService;
    @Service
    private HorseDetailsUpdateService horseDetailsUpdateService;
    @Service
    private HorseSellService horseSellService;
    @Service
    private DeathCertificateService deathCertificateService;
    @Service
    private HorseService horseService;
    @Service
    private HorseProgressionService horseProgressionService;

    @Async
    @Command(value="create")
    public Response createMenu() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.horseCreateMenuService.showHorseCreateMenuToPlayer(player);
    }

    @Async
    @Command(value="select")
    public Response selectHorse(@Arg(name="Name", suggestionProvider=HorseNameArgumentProvider.class) String name) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        Optional<EQHorse> horse = player.getHorses().getByName(name);
        if (horse.isPresent()) {
            player.getHorses().setSelected(horse.get());
            return ResponseFactory.success(I18n.getLabel("horse.selection.horse-selected"));
        }
        return ResponseFactory.fail(I18n.getLabel("horse.selection.not-selected"));
    }

    @Async
    @Commands(value={@Command(value="tp"), @Command(value="call"), @Command(value="teleport")})
    public Response tpHorse() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().requiredSelected();
        horse.getActions().processAction(new HorseRespondToCallAction(horse, player));
        return ResponseFactory.success();
    }

    @Async
    @Commands(value={@Command(value="tp"), @Command(value="call"), @Command(value="teleport")})
    public Response tpHorse(@Arg(name="Name", suggestionProvider=HorseNameArgumentProvider.class) String name) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().getHorseByName(name);
        HorsePermissionChecker.ensureHasPermissionLevel(player, horse, HorsePermissionLevel.BASIC);
        horse.getActions().processAction(new HorseRespondToCallAction(horse, player));
        return ResponseFactory.success();
    }

    @Async
    @Command(value="view")
    public Response view() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse selectedHorse = player.getHorses().requiredSelected();
        return this.horseMenuService.showMainMenu((ECPlayer)player, selectedHorse);
    }

    @Async
    @Command(value="view")
    public Response view(@Arg(name="Name", suggestionProvider=HorseNameArgumentProvider.class) String name) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.horseMenuService.showMainMenu((ECPlayer)player, name);
    }

    @Async
    @Commands(value={@Command(value="list"), @Command(value="ls")})
    public void list() {
        this.horseListService.showHorseListToPlayer(ModPlayerContext.getOnlinePlayer());
    }

    @Async
    @Command(value="set-name")
    public Response setName() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().requiredSelected();
        return this.horseDetailsUpdateService.updateHorseName(player, horse);
    }

    @Async
    @Command(value="set-name")
    public Response setName(@Arg(name="Name of horse to change", suggestionProvider=HorseNameArgumentProvider.class) String horseNameToChange) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().getHorseByName(horseNameToChange);
        return this.horseDetailsUpdateService.updateHorseName(player, horse);
    }

    @Async
    @Command(value="set-current-value")
    public Response setCurrentValue() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().requiredSelected();
        return this.horseDetailsUpdateService.updateHorseCurrentValue(player, horse);
    }

    @Async
    @Command(value="set-current-value")
    public Response setCurrentValue(@Arg(name="Name", suggestionProvider=HorseNameArgumentProvider.class) String name) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().getHorseByName(name);
        return this.horseDetailsUpdateService.updateHorseCurrentValue(player, horse);
    }

    @Async
    @Command(value="sell")
    public Response sell(@Arg(name="Name", suggestionProvider=HorseNameArgumentProvider.class) String name, @Arg(name="To Player", suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String toPlayerIgn) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().getHorseByName(name);
        return this.horseSellService.startHorseSellProcess(player, horse, toPlayerIgn);
    }

    @Async
    @Command(value="grant-access")
    public Response grantAccess(@Arg(name="Name", suggestionProvider=HorseNameArgumentProvider.class) String name, @Arg(name="To Player IGN", suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String playerIgn) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().getHorseByName(name);
        return horse.getCommandExecutor().execute(new HorseAccessGrantCommand(player, playerIgn));
    }

    @Async
    @Command(value="revoke-access")
    public Response revokeAccess(@Arg(name="Name", suggestionProvider=HorseNameArgumentProvider.class) String name, @Arg(name="From Player IGN", suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String playerIgn) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        EQHorse horse = player.getHorses().getHorseByName(name);
        return horse.getCommandExecutor().execute(new HorseAccessRevokeCommand((ECPlayer)player, playerIgn));
    }

    @Async
    @Command(value="death-certificates")
    public Response deathCertificates() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.deathCertificateService.showDeathCertificateMenu(player);
    }

    @Async
    @Command(value="progression")
    public Response showProgressionMenu() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        Optional<EQHorse> horse = player.getHorses().getSelected();
        if (horse.isPresent()) {
            return this.horseProgressionService.showHorseProgressionMenu(player, horse.get().getId());
        }
        return ResponseFactory.fail();
    }

    @Command(value="hoof-clean-tool")
    public Response onHoofCleanTool() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.horseService.giveHoofCleaningTool(player);
    }

    @Command(value="brush")
    public Response onHorseBrush() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.horseService.giveHorseBrush(player);
    }

    @Async
    @Command(value="speed-increase")
    public Response speedIncrease() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.horseService.increaseSelectedHorseSpeed(player);
    }

    @Async
    @Command(value="speed-decrease")
    public Response speedDecrease() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.horseService.decreaseSelectedHorseSpeed(player);
    }

    @Async
    @Command(value="walk-straight")
    public Response walkStraight() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.horseService.walkSelectedHorseStraight(player);
    }

    @Async
    @Command(value="lead")
    public Response lead() {
        ServerPlayer player = ModPlayerContext.getServerPlayer();
        ItemStack lead = new ItemStack((ItemLike)Items.f_42655_, 1);
        boolean added = player.m_150109_().m_36054_(lead);
        if (added) {
            return ResponseFactory.success(I18n.getLabel("horse-lead.added-to-inventory"));
        }
        player.m_36176_(lead, false);
        return ResponseFactory.success(I18n.getLabel("horse-lead.on-the-ground"));
    }
}

