/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.HorseRemovalEvent;
import com.equestricraft.mod.horse.chunk.HorseChunkChangeEvent;
import com.equestricraft.mod.horse.leash.HorseLeashDropEvent;
import com.equestricraft.mod.horse.leash.HorseLeashPutEvent;
import com.equestricraft.mod.horse.ride.HorseDismountEvent;
import com.equestricraft.mod.horse.speed.HorseSpeedService;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class HorseEventHandler {
    private static final HorseEventHandler instance = new HorseEventHandler();
    @Service
    private static HorseRepository horseRepository;
    @Service
    private static HorseSpeedService horseSpeedService;
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    public static HorseEventHandler getInstance() {
        return instance;
    }

    private HorseEventHandler() {
    }

    public void fireHorseDismounted(EntityHorse entityHorse, ServerPlayer serverPlayer) {
        EQHorse horse = (EQHorse)horseRepository.findByKey(entityHorse.getInternalId());
        ECPlayer player = this.onlinePlayerCache.requirePlayer(serverPlayer.m_142081_());
        HorseDismountEvent event = new HorseDismountEvent(entityHorse, horse, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public void fireHorseRemoval(EntityHorse entityHorse, String reasonName) {
        EQHorse horse = (EQHorse)horseRepository.findByKey(entityHorse.getInternalId());
        HorseRemovalEvent event = new HorseRemovalEvent(entityHorse, horse, reasonName);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public boolean fireLeashPutEvent(EntityHorse entityHorse, Entity leashHolder) {
        HorseLeashPutEvent event = new HorseLeashPutEvent(entityHorse, leashHolder);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public boolean fireLeashDropEvent(EntityHorse entityHorse) {
        HorseLeashDropEvent event = new HorseLeashDropEvent(entityHorse);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public void fireChunkChangeEvent(EntityHorse entityHorse) {
        EQHorse horse = (EQHorse)horseRepository.findByKey(entityHorse.getInternalId());
        HorseChunkChangeEvent event = new HorseChunkChangeEvent(entityHorse, horse);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }
}

