/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Canter;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.spook.SpookTrait;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class HorseFleeGoal
extends AbstractHorseGoal {
    private Vec3 fleePosition = null;
    private long fleeStartTime = 0L;
    private Vec3 targetPosition = null;
    private static final double TARGET_DISTANCE = 20.0;

    public HorseFleeGoal(EntityHorse horse) {
        super(horse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public void setFleePosition(Coordinate coordinate) {
        Vec3 pos = new Vec3(coordinate.x(), coordinate.y(), coordinate.z());
        this.setFleePosition(pos);
    }

    public void setFleePosition(Vec3 position) {
        this.fleePosition = position;
        this.targetPosition = this.getTargetPosition();
    }

    @Override
    public boolean shouldRun() {
        return this.fleePosition != null;
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.m_8036_() && DateUtils.secondsSince(this.fleeStartTime) < 30 && this.getDistanceFromFleePosition() < 20.0;
    }

    private double getDistanceFromFleePosition() {
        return this.entityHorse.m_20182_().m_82554_(this.fleePosition);
    }

    @Override
    public void startGoal() {
        if (this.shouldEjectPassengers()) {
            this.entityHorse.ejectPassengers(I18n.getLabel("horse.eject.flee"));
        }
        this.entityHorse.m_21573_().m_26573_();
        this.fleeStartTime = System.currentTimeMillis();
        this.entityHorse.setGait(Canter.EXTENDED);
    }

    private boolean shouldEjectPassengers() {
        EQHorse horseData = this.entityHorse.getHorseData();
        return horseData.getCurrentRide().getPlayer().map(player -> (double)horseData.getTrust().getValue((ECPlayer)player) < 0.8).orElse(true);
    }

    private Vec3 getTargetPosition() {
        Vec3 horsePosition = this.entityHorse.m_20182_();
        Vec3 awayDirection = this.entityHorse.m_20182_().m_82546_(this.fleePosition).m_82541_();
        return horsePosition.m_82549_(awayDirection.m_82490_(20.0));
    }

    @Override
    public void tickGoal() {
        this.entityHorse.m_21573_().m_26519_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, 1.0);
    }

    @Override
    public void stopGoal() {
        float idealFactorOfTarget;
        double distanceFromFleePosition = this.fleePosition.m_82554_(this.entityHorse.m_20182_());
        float factorOfTarget = (float)(distanceFromFleePosition / 20.0);
        if (factorOfTarget < (idealFactorOfTarget = this.determineIdealFactorOfTargetDistance())) {
            this.entityHorse.getHorseData().getFrustration().increment(0.5f);
        }
        this.fleePosition = null;
        this.entityHorse.m_21573_().m_26573_();
        this.entityHorse.setGait(Halt.DEFAULT);
        this.targetPosition = null;
    }

    private float determineIdealFactorOfTargetDistance() {
        return this.entityHorse.getHorseData().getTraits().getValue(SpookTrait.class);
    }
}

