/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.HorseActionType;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.action.HorseActionExecutePayload;
import com.equestricraft.core.horse.action.learnable.LearnableAction;
import com.equestricraft.core.horse.action.learnable.LearnableActionProvider;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.HorseFollowPlayerGoal;
import com.equestricraft.mod.player.OnlinePlayer;
import net.minecraft.server.level.ServerPlayer;

public class HorseFollowPlayerAction
extends LearnableAction<ActionReaction> {
    private final EntityHorse entityHorse;

    public HorseFollowPlayerAction(EQHorse horse, OnlinePlayer player, EntityHorse entityHorse) {
        super(horse, player);
        this.entityHorse = entityHorse;
    }

    @Override
    public boolean canReject() {
        return true;
    }

    @Override
    public void execute(HorseActionExecutePayload payload) {
        HorseFollowPlayerGoal goal = this.entityHorse.getFollowPlayerGoal();
        ServerPlayer focusedPlayer = goal.getPlayerToFollow();
        OnlinePlayer onlinePlayer = this.performingPlayer.require(OnlinePlayer.class);
        if (focusedPlayer != null && focusedPlayer == onlinePlayer.serverPlayer()) {
            return;
        }
        goal.setFollow(onlinePlayer.serverPlayer(), 20.0);
    }

    @Override
    public HorseActionType getType() {
        return HorseActionType.FOLLOW_PLAYER;
    }

    @Override
    public ActionReaction buildReaction(boolean reject) {
        return new ActionReaction(reject);
    }

    @Override
    public String getIdentifier() {
        return "follow_player";
    }

    public static class Provider
    implements LearnableActionProvider {
        @Override
        public LearnableAction<ActionReaction> getLearnableActionForHorse(EQHorse horse) {
            return new HorseFollowPlayerAction(horse, null, null);
        }
    }
}

