/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.aggression.AggressionTrait;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.mod.client.horse.EntityHorse;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;

public class HorseFrustrationGoal
extends PanicGoal {
    private final EntityHorse entityHorse;
    private long frustratedStateUntil = 0L;

    public HorseFrustrationGoal(EntityHorse horse) {
        super((PathfinderMob)horse, 8.0);
        this.entityHorse = horse;
    }

    protected boolean m_202729_() {
        float threshold;
        if (this.entityHorse.getHorseData() == null) {
            return false;
        }
        if (this.frustratedStateUntil > System.currentTimeMillis()) {
            return true;
        }
        float frustrationValue = this.entityHorse.getHorseData().getFrustration().getValue();
        if (frustrationValue >= (threshold = this.determineFrustrationThreshold())) {
            boolean panic;
            float probability = frustrationValue - threshold;
            boolean bl = panic = this.entityHorse.m_21187_().nextFloat() <= probability;
            if (panic) {
                this.frustratedStateUntil = DateUtils.futureSecondsOffset(10).getTime();
            }
            return panic;
        }
        return false;
    }

    private float determineFrustrationThreshold() {
        return 1.0f - this.entityHorse.getHorseData().getTraits().getValue(AggressionTrait.class);
    }

    public void m_8056_() {
        this.entityHorse.ejectPassengers(I18n.getLabel("horse.eject.frustration"));
        this.entityHorse.m_21573_().m_26573_();
        HorseSubGait gait = this.entityHorse.getHorseData().getGait().getHighestAvailable();
        this.entityHorse.setGait(gait);
        super.m_8056_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.entityHorse.m_21573_().m_26573_();
        this.entityHorse.setGait(Halt.DEFAULT);
        if (this.frustratedStateUntil < System.currentTimeMillis()) {
            this.entityHorse.getHorseData().getFrustration().setValue(0.1f);
        }
    }
}

