/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.aggression.AggressionTrait;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.horse.idleaction.HorseIdleAction;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class HorseGrazeGoal
extends AbstractHorseGoal {
    private long startTime = 0L;

    public HorseGrazeGoal(EntityHorse entityHorse) {
        super(entityHorse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean shouldRun() {
        return this.isOnGrass() && this.checkProbability() && this.wantsToEat();
    }

    private boolean isOnGrass() {
        BlockPos standingOnPos = this.entityHorse.m_20097_();
        BlockState blockState = this.entityHorse.m_183503_().m_8055_(standingOnPos);
        return blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50440_);
    }

    private boolean checkProbability() {
        float probability = this.entityHorse.isInDayTime() || this.entityHorse.getHorseData().getAge().getYears() <= 2.0 ? 0.005f : 5.0E-4f;
        return this.entityHorse.m_21187_().nextFloat() < probability;
    }

    private boolean wantsToEat() {
        return this.entityHorse.getHorseData().getProvision().getFullness() <= 0.5f;
    }

    @Override
    public boolean shouldContinueToUse() {
        return DateUtils.secondsSince(this.startTime) <= 10;
    }

    @Override
    public void startGoal() {
        this.entityHorse.setIdleAnimation(HorseIdleAction.GRAZING.getRandomAnimation());
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void stopGoal() {
        TaskScheduler.executeAsyncTask(this::processFinish);
        this.entityHorse.setIdleAnimation(HorseIdleAction.RESTING.getRandomAnimation());
    }

    private void processFinish() {
        float frustration;
        long millisRunningFor = DateUtils.millisSince(this.startTime);
        long completion = millisRunningFor / 10000L;
        long gramsToGive = (long)HorseSettings.getGramsOfFoodFromGraze() * completion;
        if (gramsToGive > 0L) {
            this.entityHorse.getHorseData().getProvision().giveGramsOfFood(gramsToGive);
        }
        if ((frustration = this.determineFrustrationIncrease(completion)) > 0.0f) {
            this.entityHorse.getHorseData().getFrustration().increment(frustration);
        }
    }

    private float determineFrustrationIncrease(float completion) {
        float amount = (1.0f - completion) * 0.2f;
        return amount *= this.entityHorse.getHorseData().getTraits().getValue(AggressionTrait.class);
    }
}

