/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.log.HorseActionLogSession;
import com.equestricraft.mod.horse.HorseSpookAction;
import java.util.concurrent.ThreadLocalRandom;

public class HorseLightningStrikeAction
extends HorseSpookAction {
    @Service
    private static HorseActionLogSession horseActionLogSession;

    public HorseLightningStrikeAction(EQHorse horse) {
        super(horse);
    }

    @Override
    public boolean forceReject() {
        int lightingStrikeCount = horseActionLogSession.getCountOfAction(this.horse, HorseActionType.LIGHTING_STRIKE);
        float factor = (float)(lightingStrikeCount - 20) / 20.0f;
        return factor >= ThreadLocalRandom.current().nextFloat();
    }

    @Override
    public HorseActionType getType() {
        return HorseActionType.LIGHTING_STRIKE;
    }

    @Override
    public String getIdentifier() {
        return "lightning_strike";
    }
}

