/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.base.ClickType;
import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.death.ECHorseDeathEvent;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.horse.SelectedHorseChangeEvent;
import com.equestricraft.core.weather.event.WindGustEvent;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.client.item.HoofCleaningTool;
import com.equestricraft.mod.client.item.HorseBrush;
import com.equestricraft.mod.horse.HorseLightningStrikeAction;
import com.equestricraft.mod.horse.HorseRemovalEvent;
import com.equestricraft.mod.horse.HorseService;
import com.equestricraft.mod.horse.HorseWindGustAction;
import com.equestricraft.mod.horse.PlayerInteractHorseEvent;
import com.equestricraft.mod.horse.breeding.BreedingService;
import com.equestricraft.mod.horse.breeding.HorseNaturalBreedAcceptEvent;
import com.equestricraft.mod.horse.breeding.HorseNaturalBreedRejectEvent;
import com.equestricraft.mod.horse.cache.HorseEntityCache;
import com.equestricraft.mod.horse.chunk.HorseChunkChangeEvent;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.horse.leash.HorseLeashDropEvent;
import com.equestricraft.mod.horse.leash.HorseLeashPutEvent;
import com.equestricraft.mod.horse.leashpolicy.HorseLeashPolicy;
import com.equestricraft.mod.player.ECPlayerLeaveEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.ChunkPosUtil;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class HorseListener {
    @Service
    private static StandardHorseEntitySession standardHorseEntitySession;
    @Service
    private static BreedingService breedingService;
    @Service
    private static HorseService horseService;
    private static final HorseEntityCache horseEntityCache;

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkPos pos = event.getChunk().m_7697_();
        HorseListener.clearHorsesInChunk((ServerLevel)event.getWorld().m_7726_().m_7653_(), pos);
        TaskScheduler.executeSyncTask(() -> {
            ECLevel ecLevel = ServerLevelUtil.getECLevel((Level)((ServerLevel)event.getWorld().m_7726_().m_7653_()));
            List<EQHorse> horsesInChunk = horseEntityCache.getHorsesInDimensionChunk(ecLevel, pos);
            horsesInChunk.stream().filter(Predicate.not(EQHorse::isDead)).filter(Predicate.not(h -> horseEntityCache.isHorseActive(h.getId()))).forEach(h -> TaskScheduler.executeAsyncTask(() -> standardHorseEntitySession.spawnHorse((EQHorse)h)));
        });
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ServerLevel serverLevel = (ServerLevel)event.getWorld().m_7726_().m_7653_();
        for (EntityHorse entity : serverLevel.m_143280_(EntityTypeTest.m_156916_(EntityHorse.class), e -> e.m_146902_().equals((Object)event.getChunk().m_7697_()) && e.getHorseEntityType() == HorseEntityType.STANDARD)) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private static void clearHorsesInChunk(ServerLevel level, ChunkPos chunkPos) {
        List horsesToRemove = level.m_143280_(EntityTypeTest.m_156916_(EntityHorse.class), horse -> {
            if (horse.getHorseEntityType() != HorseEntityType.STANDARD) {
                return false;
            }
            return horse.m_146902_().equals((Object)chunkPos);
        });
        for (EntityHorse horse2 : horsesToRemove) {
            horse2.m_142687_(Entity.RemovalReason.DISCARDED);
            horseEntityCache.removeEntityForHorse(horse2.getInternalId());
        }
    }

    @SubscribeEvent
    public static void onHorseRemove(HorseRemovalEvent event) {
        if (event.getHorse() != null) {
            TaskScheduler.executeAsyncTask(() -> HorseListener.saveLocation(event.getHorse(), event.getEntityHorse()));
        }
    }

    @SubscribeEvent
    public static void onHorseSave(HorseChunkChangeEvent event) {
        if (event.getHorse() != null) {
            TaskScheduler.executeAsyncTask(() -> HorseListener.saveLocation(event.getHorse(), event.getEntityHorse()));
        }
    }

    @SubscribeEvent
    public static void onHorseLeash(HorseLeashPutEvent event) {
        EntityHorse horse = event.getEntityHorse();
        HorseLeashPolicy policy = horse.getLeashPolicy();
        if (policy.canLeash(horse)) {
            policy.onLeash(horse, event.getLeashHolder());
        } else {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHorseLeashDrop(HorseLeashDropEvent event) {
        boolean cancelled;
        EntityHorse horse = event.getEntityHorse();
        HorseLeashPolicy policy = horse.getLeashPolicy();
        if (policy.canLeash(horse) && (cancelled = policy.onUnLeash(horse, horse.m_21524_()))) {
            event.setCanceled(true);
        }
    }

    private static void saveLocation(EQHorse horse, EntityHorse horseEntity) {
        DirectionalCoordinate coord = new DirectionalCoordinate(horseEntity.m_20185_(), horseEntity.m_20186_(), horseEntity.m_20189_(), ServerLevelUtil.getEntitiesServerLevelIdentifier((Entity)horseEntity), horseEntity.m_146908_() % 180.0f, horseEntity.m_146909_());
        horse.setDirectionalCoordinate(coord);
        horse.save();
        ECLevel level = ServerLevelUtil.getEntitiesECLevel((Entity)horseEntity);
        ChunkPos chunk = ChunkPosUtil.toChunkPos(horseEntity.m_146903_(), horseEntity.m_146907_());
        horseEntityCache.updateLocation(horse, level, chunk);
    }

    @SubscribeEvent
    public static void onHorseAttack(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof EntityHorse) {
            EntityHorse entityHorse = (EntityHorse)entity;
            entity = event.getPlayer();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                boolean cancelled = entityHorse.getInteractPolicy().onHorseInteract(entityHorse, serverPlayer, ClickType.LEFT, serverPlayer.m_6144_());
                event.setCanceled(cancelled);
            }
        }
    }

    @ECEventBusListener
    public static void onHorseDeath(ECHorseDeathEvent event) {
        standardHorseEntitySession.despawnHorse(event.getHorse());
        horseEntityCache.removeHorse(event.getHorse());
    }

    @ECEventBusListener
    public static void onHorseSelectionChange(SelectedHorseChangeEvent event) {
        OnlinePlayer onlinePlayer = event.getPlayer().require(OnlinePlayer.class);
        if (event.getHorse() != null) {
            onlinePlayer.getDisplay().getSelectedHorse().setSelectedHorseName(event.getHorse().getName());
        } else {
            onlinePlayer.getDisplay().getSelectedHorse().setSelectedHorseName(null);
        }
    }

    @SubscribeEvent
    public static void onHorseBreedStart(HorseNaturalBreedAcceptEvent event) {
        breedingService.naturallyBreedHorses(event.getMare(), event.getStallion());
    }

    @SubscribeEvent
    public static void onHorseBreedReject(HorseNaturalBreedRejectEvent event) {
        breedingService.rejectBreeding(event.getMare(), event.getStallion());
    }

    @SubscribeEvent
    public static void onHoofCleaningToolUse(PlayerInteractHorseEvent event) {
        ItemStack item = event.getItemInHand();
        if (item.m_41720_() instanceof HoofCleaningTool) {
            TaskScheduler.executeAsyncTask(() -> {
                Response response = horseService.processHoofCleanToolUse(event.getPlayer().require(OnlinePlayer.class), event.getHorse());
                event.getPlayer().showResponse(response);
            });
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHorseBrushUse(PlayerInteractHorseEvent event) {
        ItemStack item = event.getItemInHand();
        if (item.m_41720_() instanceof HorseBrush) {
            TaskScheduler.executeAsyncTask(() -> {
                Response response = horseService.processHorseBrushUse(event.getPlayer().require(OnlinePlayer.class), event.getHorse());
                event.getPlayer().showResponse(response);
            });
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHorseFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityHorse) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLightningStrike(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LightningBolt) {
            LightningBolt lightningBolt = (LightningBolt)entity;
            Vec3 lightningPosition = lightningBolt.m_20182_();
            ServerLevel serverLevel = (ServerLevel)lightningBolt.m_183503_();
            for (Entity entity2 : serverLevel.m_8583_()) {
                EntityHorse entityHorse;
                Vec3 horsePosition;
                double distance;
                if (!(entity2 instanceof EntityHorse) || !((distance = lightningPosition.m_82554_(horsePosition = (entityHorse = (EntityHorse)entity2).asMob().m_20182_())) <= (double)HorseSettings.getLightningFearDistanceBlocks().intValue())) continue;
                EQHorse horse = entityHorse.getHorseData();
                TaskScheduler.executeAsyncTask(() -> horse.getActions().processAction(new HorseLightningStrikeAction(horse)));
            }
        }
    }

    @ECEventBusListener
    public static void onWindGust(WindGustEvent event) {
        List<EQHorse> activeHorses = horseEntityCache.getActiveHorses();
        activeHorses.forEach(h -> h.getActions().processAction(new HorseWindGustAction((EQHorse)h)));
    }

    @ECEventBusListener
    public static void onPlayerLeave(ECPlayerLeaveEvent event) {
        ECPlayer player = event.getPlayer();
        for (EQHorse horse : player.getHorses().getLiving()) {
            if (!horse.getLocation().getLocation().filter(l -> l.world().equals(ECLevel.EXPLORE.getIdentifier())).isPresent()) continue;
            standardHorseEntitySession.despawnHorse(horse);
        }
    }

    private HorseListener() {
    }

    static {
        horseEntityCache = HorseEntityCache.getInstance();
    }
}

