/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.common.HorseLogType;
import com.equestricraft.common.ProvisionType;
import com.equestricraft.core.horse.provision.HorseProvisionGiveEvent;
import com.equestricraft.mod.horse.ride.HorseDismountEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class HorseLogListener {
    @ECEventBusListener
    public static void onProvisionGive(HorseProvisionGiveEvent event) {
        if (event.getGivingPlayer() == null) {
            return;
        }
        HorseLogType logType = switch (event.getProvisionType()) {
            default -> throw new IncompatibleClassChangeError();
            case ProvisionType.FOOD -> HorseLogType.FEED;
            case ProvisionType.DRINK -> HorseLogType.DRINK;
        };
        event.getHorse().getLogs().log(event.getGivingPlayer(), logType, "Horse has been given provision {0}", event.getProvisionName());
    }

    @SubscribeEvent
    public static void onDismount(HorseDismountEvent event) {
        event.getHorse().getLogs().log(event.getPlayer(), HorseLogType.RIDE, "Horse was ridden", new Object[0]);
    }

    private HorseLogListener() {
    }
}

