/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.spook.SpookTrait;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import java.time.Duration;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;

public class HorsePanicGoal
extends PanicGoal {
    private final EntityHorse entityHorse;
    private Long panicUntil = null;

    public HorsePanicGoal(EntityHorse horse) {
        super((PathfinderMob)horse, 8.0);
        this.entityHorse = horse;
    }

    protected boolean m_202729_() {
        if (super.m_202729_()) {
            return true;
        }
        if (this.panicUntil == null) {
            return false;
        }
        if (this.panicUntil > System.currentTimeMillis()) {
            return !this.isCalmedByRider();
        }
        this.panicUntil = null;
        return false;
    }

    private boolean isCalmedByRider() {
        EQHorse horseData = this.entityHorse.getHorseData();
        if (horseData.getAge().getYears() < 2.0) {
            return false;
        }
        return horseData.getCurrentRide().getPlayer().filter(player -> (float)horseData.getTrust().getValue((ECPlayer)player) >= horseData.getTraits().getValue(SpookTrait.class) * 100.0f).isPresent();
    }

    public void setPanicDuration(Duration duration) {
        this.panicUntil = DateUtils.futureDurationOffset(duration).getTime();
    }

    public void m_8056_() {
        this.entityHorse.ejectPassengers(I18n.getLabel("horse.eject.panic"));
        this.entityHorse.m_21573_().m_26573_();
        HorseSubGait gait = this.entityHorse.getHorseData().getGait().getHighestAvailable();
        this.entityHorse.setGait(gait);
        super.m_8056_();
    }

    public void m_8041_() {
        this.entityHorse.m_21573_().m_26573_();
        this.entityHorse.setGait(Halt.DEFAULT);
        super.m_8041_();
    }
}

