/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.action.HorseAction;
import com.equestricraft.core.horse.action.HorseActionExecutePayload;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.entity.HorseTeleportTimeCache;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

public class HorseRespondToCallAction
extends HorseAction<ActionReaction> {
    private final OnlinePlayer player;
    @Service
    private static StandardHorseEntitySession standardHorseEntitySession;
    private static final HorseTeleportTimeCache horseTeleportTimeCache;

    public HorseRespondToCallAction(EQHorse horse, OnlinePlayer player) {
        super(horse);
        this.player = player;
    }

    @Override
    protected boolean forceReject() {
        HorseRecentTeleportCheckResponse response = this.checkRecentTeleportForHorse(this.horse, this.player);
        boolean needsToWait = response.needsToWait();
        if (needsToWait) {
            this.player.sendMessage(I18n.getLabel("horse.call.wait-for-cool-down", response.secondsToWait()));
        }
        return needsToWait;
    }

    private HorseRecentTeleportCheckResponse checkRecentTeleportForHorse(EQHorse horse, OnlinePlayer player) {
        Optional<Long> lastTeleportTime = horseTeleportTimeCache.getTimePlayerLastTeleportedHorse(player.getId(), horse.getId());
        if (lastTeleportTime.isPresent()) {
            int secondsSince = DateUtils.secondsSince(lastTeleportTime.get());
            int secondsToWait = HorseSettings.getTeleportHorseCoolDownSeconds() - secondsSince;
            return HorseRecentTeleportCheckResponse.wait(secondsToWait);
        }
        return HorseRecentTeleportCheckResponse.noWait();
    }

    @Override
    protected void execute(HorseActionExecutePayload payload) {
        Optional<EntityHorse> entityHorse = standardHorseEntitySession.findEntityForHorse(this.horse);
        if (entityHorse.isPresent()) {
            entityHorse.get().getResponseToCallGoal().targetPlayer(this.player);
        } else {
            standardHorseEntitySession.teleportHorse(this.horse, this.player);
        }
        horseTeleportTimeCache.logPlayerTeleportHorse(this.player.getId(), this.horse.getId());
    }

    @Override
    public HorseActionType getType() {
        return HorseActionType.RESPOND_TO_CALL;
    }

    @Override
    protected ActionReaction buildReaction(boolean reject) {
        return new ActionReaction(reject);
    }

    @Override
    public String getIdentifier() {
        return "respond_to_call";
    }

    static {
        horseTeleportTimeCache = HorseTeleportTimeCache.getInstance();
    }

    private record HorseRecentTeleportCheckResponse(int secondsToWait) {
        boolean needsToWait() {
            return this.secondsToWait > 0;
        }

        static HorseRecentTeleportCheckResponse wait(int seconds) {
            return new HorseRecentTeleportCheckResponse(seconds);
        }

        static HorseRecentTeleportCheckResponse noWait() {
            return HorseRecentTeleportCheckResponse.wait(0);
        }
    }
}

