/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.EnumSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class HorseRespondToCallGoal
extends AbstractHorseGoal {
    private OnlinePlayer player = null;
    private Long startTime = null;
    private Long reachTime = null;

    public HorseRespondToCallGoal(EntityHorse entityHorse) {
        super(entityHorse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public void targetPlayer(OnlinePlayer player) {
        this.player = player;
    }

    public void cancel() {
        this.m_8041_();
    }

    @Override
    public boolean shouldRun() {
        return this.player != null;
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.m_8036_() && (this.reachTime == null || DateUtils.secondsSince(this.reachTime) < 3);
    }

    @Override
    public void startGoal() {
        OnlinePlayer p = this.player;
        if (p == null) {
            return;
        }
        this.entityHorse.m_21573_().m_26573_();
        ServerPlayer serverPlayer = p.serverPlayer();
        Path path = this.entityHorse.m_21573_().m_6570_((Entity)serverPlayer, 1);
        if (path == null || !path.m_77403_()) {
            this.entityHorse.m_146884_(serverPlayer.m_20182_());
            this.reachTime = System.currentTimeMillis();
            this.m_8041_();
            return;
        }
        HorseSubGait gait = this.entityHorse.getHorseData().getGait().getHighestAvailable();
        this.entityHorse.setGait(gait);
        this.entityHorse.m_21573_().m_26536_(path, 1.0);
        p.sendMessage(I18n.getLabel("horse.call.horse-on-the-way"));
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void tickGoal() {
        if (this.reachTime == null) {
            if (this.entityHorse.m_21573_().m_26571_()) {
                this.reachTime = System.currentTimeMillis();
                if (this.player != null) {
                    this.player.sendMessage(I18n.getLabel("horse.call.arrived"));
                }
                this.entityHorse.setGait(Halt.DEFAULT);
                return;
            }
            if (DateUtils.secondsSince(this.startTime) >= 30) {
                if (this.player != null) {
                    this.player.sendMessage(I18n.getLabel("horse.call.timeout"));
                    ServerPlayer serverPlayer = this.player.serverPlayer();
                    this.entityHorse.m_146884_(serverPlayer.m_20182_());
                }
                this.entityHorse.setGait(Halt.DEFAULT);
            }
        }
    }

    @Override
    public void stopGoal() {
        if (this.reachTime == null && this.player != null) {
            this.player.sendMessage(I18n.getLabel("horse.call.horse-navigation-stopped"));
        }
        this.player = null;
        this.entityHorse.m_21573_().m_26573_();
        this.reachTime = null;
        this.startTime = null;
    }
}

