/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.lineage.LineageSession;
import com.equestricraft.core.horse.lineage.TreeNode;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.item.HoofCleaningTool;
import com.equestricraft.mod.client.item.HorseBrush;
import com.equestricraft.mod.client.item.ModItems;
import com.equestricraft.mod.horse.HorseService;
import com.equestricraft.mod.horse.HorseWalkStraightGoal;
import com.equestricraft.mod.horse.LineageNodeMenuItem;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.horse.speed.HorseSpeedService;
import com.equestricraft.mod.packet.ClientBoundLineageMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.ComponentUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HorseServiceImpl
implements HorseService {
    @Service
    private HorseRepository horseRepository;
    @Service
    private LineageSession lineageSession;
    @Service
    private HorseSpeedService horseSpeedService;
    @Service
    private StandardHorseEntitySession standardHorseEntitySession;

    @Override
    public List<String> getPlayersHorseNames(ECPlayer player) {
        return player.getHorses().getLiving().stream().map(EQHorse::getName).filter(Objects::nonNull).distinct().toList();
    }

    @Override
    public void showLinageMenu(OnlinePlayer player, int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        TreeNode node = this.lineageSession.buildHorsesLineageTree(horse, 3);
        LineageNodeMenuItem nodeItem = this.transform(node);
        ClientBoundLineageMenuOpenPacket packet = new ClientBoundLineageMenuOpenPacket(nodeItem);
        player.sendPacket(packet);
    }

    private LineageNodeMenuItem transform(TreeNode node) {
        LineageNodeMenuItem mother = null;
        LineageNodeMenuItem father = null;
        if (node.hasNextLevel()) {
            mother = this.transform(node.mother());
            father = this.transform(node.father());
        }
        Float corValue = node.horse().getLineage().isUnlocked() ? Float.valueOf(node.horse().getLineage().getCoefficientOfRelationship()) : null;
        return new LineageNodeMenuItem(node.horse().getId(), node.horse().getName(), !node.horse().isDead(), corValue, mother, father);
    }

    @Override
    public Response giveHoofCleaningTool(OnlinePlayer player) {
        HoofCleaningTool item = ModItems.getHoofCleaningTool();
        ItemStack tool = new ItemStack((ItemLike)item);
        tool.m_41714_((Component)ComponentUtil.buildColoredTextComponent("Hoof Cleaning Tool"));
        player.serverPlayer().m_150109_().m_36054_(tool);
        return ResponseFactory.success();
    }

    @Override
    public Response processHoofCleanToolUse(OnlinePlayer player, EQHorse horse) {
        horse.getCare().cleanHooves();
        return ResponseFactory.success(I18n.getLabel("horse.hoof-cleaning-tool.used"));
    }

    @Override
    public Response giveHorseBrush(OnlinePlayer player) {
        HorseBrush item = ModItems.getHorseBrush();
        ItemStack tool = new ItemStack((ItemLike)item);
        tool.m_41714_((Component)ComponentUtil.buildColoredTextComponent("Horse Brush"));
        player.serverPlayer().m_150109_().m_36054_(tool);
        return ResponseFactory.success();
    }

    @Override
    public Response processHorseBrushUse(OnlinePlayer player, EQHorse horse) {
        horse.getCare().brush();
        return ResponseFactory.success(I18n.getLabel("horse.brush.used"));
    }

    @Override
    public Response increaseSelectedHorseSpeed(OnlinePlayer player) {
        Optional h = player.getHorses().getSelected().flatMap(this.standardHorseEntitySession::findEntityForHorse);
        h.ifPresent(entityHorse -> this.horseSpeedService.incrementHorseGait((EntityHorse)entityHorse, player));
        return ResponseFactory.success();
    }

    @Override
    public Response decreaseSelectedHorseSpeed(OnlinePlayer player) {
        Optional h = player.getHorses().getSelected().flatMap(this.standardHorseEntitySession::findEntityForHorse);
        h.ifPresent(entityHorse -> this.horseSpeedService.decrementHorseGait((EntityHorse)entityHorse, player));
        return ResponseFactory.success();
    }

    @Override
    public Response walkSelectedHorseStraight(OnlinePlayer player) {
        Optional<HorseWalkStraightGoal> h = player.getHorses().getSelected().flatMap(this.standardHorseEntitySession::findEntityForHorse);
        h.map(EntityHorse::getWalkStraightGoal).ifPresent(HorseWalkStraightGoal::toggle);
        return ResponseFactory.success();
    }
}

