/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class HorseSlowDownStraightGoal
extends AbstractHorseGoal {
    private boolean shouldBeActive = false;
    private long lastSpeedReduction = 0L;

    public HorseSlowDownStraightGoal(EntityHorse entityHorse) {
        super(entityHorse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public void activate() {
        this.shouldBeActive = true;
    }

    @Override
    public boolean shouldRun() {
        return this.shouldBeActive;
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.shouldBeActive && !this.entityHorse.m_21573_().m_26571_();
    }

    @Override
    public void startGoal() {
        this.entityHorse.m_21573_().m_26573_();
        Vec3 looking = this.entityHorse.m_20154_().m_82541_();
        Vec3 targetPos = this.entityHorse.m_20182_().m_82549_(looking.m_82490_(10.0));
        this.entityHorse.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.0);
        this.setLastSpeedReduction();
    }

    @Override
    public void tickGoal() {
        if (this.timeForSpeedReduction()) {
            HorseSubGait gait = this.entityHorse.getGait().getMainGait().getPrevious().getDefaultGait();
            if (gait == null) {
                this.shouldBeActive = false;
                return;
            }
            this.entityHorse.setGait(gait);
            if (gait.getBlocksPerSecond() == 0.0f) {
                this.shouldBeActive = false;
            }
            this.setLastSpeedReduction();
        }
    }

    private void setLastSpeedReduction() {
        this.lastSpeedReduction = System.currentTimeMillis();
    }

    private boolean timeForSpeedReduction() {
        return DateUtils.durationSince(this.lastSpeedReduction).toSeconds() >= 3L;
    }

    @Override
    public void stopGoal() {
        this.shouldBeActive = false;
        this.entityHorse.m_21573_().m_26573_();
    }
}

