/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.action.HorseAction;
import com.equestricraft.core.horse.action.HorseActionExecutePayload;
import com.equestricraft.core.horse.spook.SpookTrait;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.entity.StandardHorseEntitySession;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public abstract class HorseSpookAction
extends HorseAction<ActionReaction> {
    @Service
    private static StandardHorseEntitySession standardHorseEntitySession;

    protected HorseSpookAction(EQHorse horse) {
        super(horse);
    }

    @Override
    protected boolean affectsTack() {
        return true;
    }

    @Override
    protected boolean forceReject() {
        return this.horse.getTraits().getValue(SpookTrait.class) < 0.5f;
    }

    @Override
    public void execute(HorseActionExecutePayload payload) {
        Optional<EntityHorse> entityHorse = standardHorseEntitySession.findEntityForHorse(this.horse);
        entityHorse.ifPresent(h -> h.fleeFrom(this.determineFleeFromPosition((EntityHorse)h)));
    }

    private Vec3 determineFleeFromPosition(EntityHorse entityHorse) {
        if (this.performingPlayer == null) {
            return entityHorse.m_20182_().m_82520_((double)entityHorse.m_21187_().nextInt(2), 0.0, (double)entityHorse.m_21187_().nextInt(2));
        }
        ServerPlayer serverPlayer = this.performingPlayer.require(OnlinePlayer.class).serverPlayer();
        return serverPlayer.m_20182_();
    }

    @Override
    public ActionReaction buildReaction(boolean reject) {
        return new ActionReaction(reject);
    }
}

