/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseGait;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.gait.Trot;
import com.equestricraft.core.horse.gait.Walk;
import com.equestricraft.core.horse.restless.RestlessTrait;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.pathfinder.Path;

public abstract class HorseWanderGoal
extends AbstractHorseGoal {
    private long lastSpeedChange = 0L;
    private int secondsUntilNextSpeedChange = 0;
    private long lastWander = 0L;
    private static final List<HorseSubGait> startingGaits = List.of(Walk.COLLECTED, Walk.WORKING, Walk.EXTENDED, Trot.COLLECTED, Trot.WORKING, Trot.EXTENDED);

    HorseWanderGoal(EntityHorse horse) {
        super(horse);
    }

    @Override
    public final boolean shouldRun() {
        if (this.entityHorse.getHorseData() == null) {
            return false;
        }
        if (this.entityHorse.getHorseData().getStamina().getPercentage() < HorseSettings.getWanderMinimumStaminaPercentage()) {
            return false;
        }
        if (this.entityHorse.m_20160_()) {
            return false;
        }
        if (DateUtils.secondsSince(this.lastWander) <= 30) {
            return false;
        }
        return this.shouldUse();
    }

    @Override
    public final boolean shouldContinueToUse() {
        return !this.entityHorse.m_21573_().m_26571_() && !this.entityHorse.m_20160_() && this.entityHorse.getHorseData() != null && this.shouldContinueToWander();
    }

    abstract boolean shouldUse();

    boolean shouldContinueToWander() {
        return this.shouldUse();
    }

    @Override
    public void startGoal() {
        HorseSubGait gait = this.getValidStartingGait();
        if (gait == Halt.DEFAULT) {
            this.m_8041_();
            return;
        }
        this.setSpeed(gait);
        this.entityHorse.m_21573_().m_26573_();
        Optional<Path> path = this.createValidWanderPath();
        if (path.isPresent()) {
            this.entityHorse.m_21573_().m_26536_(path.get(), 1.0);
            this.lastWander = System.currentTimeMillis();
        } else {
            this.entityHorse.getHorseData().getFrustration().increment(this.determineFrustrationIncrementAmount());
            this.m_8041_();
        }
    }

    private Optional<Path> createValidWanderPath() {
        for (int i = 0; i < this.determineSearchAttempts(); ++i) {
            Path path = this.getPath();
            if (path == null || !path.m_77403_()) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    }

    private int determineSearchAttempts() {
        return (int)(this.entityHorse.getHorseData().getIntelligence().getValue() * 10.0f);
    }

    private float determineFrustrationIncrementAmount() {
        float value = this.entityHorse.getHorseData().getTraits().getValue(RestlessTrait.class) / 5.0f;
        return NumberUtils.keepWithinRange(Float.valueOf(value), Float.valueOf(0.0f), Float.valueOf(0.2f)).floatValue();
    }

    @Override
    public void tickGoal() {
        if (this.getSecondsSinceLastSpeedChange() > this.secondsUntilNextSpeedChange) {
            HorseGait newGait = this.entityHorse.m_21187_().nextBoolean() ? this.entityHorse.getSpeedControlPolicy().getNextGait(this.entityHorse) : this.entityHorse.getSpeedControlPolicy().getPreviousGait(this.entityHorse);
            HorseSubGait newSubGait = newGait.getDefaultGait();
            if (newSubGait == Halt.DEFAULT) {
                return;
            }
            if (this.entityHorse.getSpeedControlPolicy().isWarmedUpForGait(this.entityHorse, newSubGait)) {
                this.setSpeed(newSubGait);
            }
        }
    }

    private void setSpeed(HorseSubGait gait) {
        this.entityHorse.setGait(gait);
        this.lastSpeedChange = System.currentTimeMillis();
        this.secondsUntilNextSpeedChange = NumberUtils.randomIntInRange(HorseSettings.getWanderMinimumSpeedChangeSeconds(), HorseSettings.getWanderMaximumSpeedChangeSeconds());
    }

    private int getSecondsSinceLastSpeedChange() {
        return DateUtils.secondsSince(this.lastSpeedChange);
    }

    @Override
    public void stopGoal() {
        this.entityHorse.m_21573_().m_26573_();
        this.entityHorse.setGait(Halt.DEFAULT);
    }

    abstract Path getPath();

    private HorseSubGait getValidStartingGait() {
        List<HorseSubGait> gaits = startingGaits.stream().sorted(Comparator.comparing(HorseSubGait::getBlocksPerSecond).reversed()).filter(g -> this.entityHorse.getSpeedControlPolicy().isWarmedUpForGait(this.entityHorse, (HorseSubGait)g)).toList();
        if (gaits.isEmpty()) {
            return Halt.DEFAULT;
        }
        return ListUtils.getRandomItem(gaits);
    }
}

