/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class HorseWanderToParentGoal
extends AbstractHorseGoal {
    private long lastSearch = 0L;

    public HorseWanderToParentGoal(EntityHorse entityHorse) {
        super(entityHorse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    @Override
    public boolean shouldRun() {
        return this.entityHorse.getHorseData().hasParents() && DateUtils.millisSince(this.lastSearch) >= this.determineCooldown().toMillis();
    }

    private Duration determineCooldown() {
        int ageMonths = this.entityHorse.getHorseData().getAge().getMonths();
        if (ageMonths < 12) {
            return Duration.ofMinutes(5L);
        }
        if (ageMonths < 24) {
            return Duration.ofMinutes(30L);
        }
        return Duration.ofHours(2L);
    }

    @Override
    public void startGoal() {
        this.entityHorse.m_21573_().m_26573_();
        List nearbyHorses = this.entityHorse.f_19853_.m_45971_(EntityHorse.class, TargetingConditions.m_148353_(), (LivingEntity)this.entityHorse, new AABB(this.entityHorse.m_142538_()).m_82400_(this.determineSearchDistance()));
        Optional<EntityHorse> nearbyParent = nearbyHorses.stream().filter(e -> e.getHorseEntityType() == HorseEntityType.STANDARD).filter(e -> e.getHorseData() != null).filter(this::isParent).findFirst();
        HorseSubGait gait = this.entityHorse.getHorseData().getGait().getHighestAvailable();
        this.entityHorse.setGait(gait);
        if (nearbyParent.isPresent()) {
            this.entityHorse.m_21573_().m_5624_((Entity)nearbyParent.get(), 1.0);
        } else {
            this.entityHorse.getHorseData().getFrustration().increment(this.determineFrustrationIncrease());
        }
        this.lastSearch = System.currentTimeMillis();
    }

    @Override
    public void stopGoal() {
        this.entityHorse.m_21573_().m_26573_();
        this.entityHorse.setGait(Halt.DEFAULT);
    }

    private double determineSearchDistance() {
        return 20.0 * (double)this.entityHorse.getHorseData().getIntelligence().getValue();
    }

    private boolean isParent(EntityHorse nearbyParent) {
        EQHorse horseData = nearbyParent.getHorseData();
        if (!horseData.hasParents()) {
            return false;
        }
        EQHorse foalData = this.entityHorse.getHorseData();
        return foalData.getMotherId().equals(horseData.getId()) || foalData.getFatherId().equals(horseData.getId());
    }

    private float determineFrustrationIncrease() {
        int ageMonths = this.entityHorse.getHorseData().getAge().getMonths();
        if (ageMonths < 12) {
            return 0.3f;
        }
        if (ageMonths < 24) {
            return 0.2f;
        }
        return 0.0f;
    }
}

