/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class HorseWanderToPlayerGoal
extends AbstractHorseGoal {
    private ServerPlayer targetPlayer = null;
    @Service
    private static PlayerService playerService;

    public HorseWanderToPlayerGoal(EntityHorse entityHorse) {
        super(entityHorse);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    @Override
    public boolean shouldRun() {
        return this.entityHorse.m_20197_().isEmpty() && this.wantsToFind();
    }

    private boolean wantsToFind() {
        return this.entityHorse.m_21187_().nextFloat() <= 0.005f;
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.entityHorse.m_20197_().isEmpty() && this.targetPlayer != null && this.entityHorse.m_20270_((Entity)this.targetPlayer) <= 2.0f;
    }

    @Override
    public void startGoal() {
        record PlayerPair(ServerPlayer serverPlayer, CorePlayer corePlayer) {
        }
        this.entityHorse.m_21573_().m_26573_();
        EQHorse horseData = this.entityHorse.getHorseData();
        List nearbyPlayers = this.entityHorse.m_183503_().m_45971_(ServerPlayer.class, TargetingConditions.m_148353_(), (LivingEntity)this.entityHorse, new AABB(this.entityHorse.m_142538_()).m_82400_(this.determineSearchDistance()));
        int minimumTrustLevel = this.determineTrustLevel();
        Optional<ServerPlayer> foundPlayer = nearbyPlayers.stream().map(p -> {
            CorePlayer corePlayer = playerService.retrievePlayerByAccountUuid(p.m_142081_());
            return new PlayerPair((ServerPlayer)p, corePlayer);
        }).filter(p -> horseData.getTrust().getValue(p.corePlayer) >= minimumTrustLevel).filter(p -> {
            Path path = this.entityHorse.m_21573_().m_6570_((Entity)p.serverPlayer, 1);
            return path != null && path.m_77403_();
        }).findAny().map(p -> p.serverPlayer);
        if (foundPlayer.isPresent()) {
            this.targetPlayer = foundPlayer.get();
            HorseSubGait gait = horseData.getGait().getHighestAvailable();
            this.entityHorse.setGait(gait);
        } else {
            this.m_8041_();
        }
    }

    private double determineSearchDistance() {
        float additionalDistance = this.entityHorse.getHorseData().getIntelligence().getValue() * 10.0f;
        return 5.0f + additionalDistance;
    }

    private int determineTrustLevel() {
        double ageYears = this.entityHorse.getHorseData().getAge().getYears();
        if (ageYears <= 2.0) {
            return 60;
        }
        if (ageYears <= 10.0) {
            return 50;
        }
        return 70;
    }

    @Override
    public void tickGoal() {
        ServerPlayer p = this.targetPlayer;
        if (p != null) {
            this.entityHorse.m_21573_().m_5624_((Entity)p, 1.0);
        }
    }

    @Override
    public void stopGoal() {
        this.targetPlayer = null;
        this.entityHorse.setGait(Halt.DEFAULT);
        this.entityHorse.m_21573_().m_26573_();
    }
}

