/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.log.HorseActionLogSession;
import com.equestricraft.mod.horse.HorseSpookAction;
import java.util.concurrent.ThreadLocalRandom;

public class HorseWindGustAction
extends HorseSpookAction {
    @Service
    private static HorseActionLogSession horseActionLogSession;

    public HorseWindGustAction(EQHorse horse) {
        super(horse);
    }

    @Override
    public boolean forceReject() {
        int windGustCount = horseActionLogSession.getCountOfAction(this.horse, HorseActionType.WIND_GUST);
        float factor = (float)(windGustCount - 20) / 20.0f;
        return factor >= ThreadLocalRandom.current().nextFloat();
    }

    @Override
    public HorseActionType getType() {
        return HorseActionType.WIND_GUST;
    }

    @Override
    public String getIdentifier() {
        return "wind_gust";
    }
}

