/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.access;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.access.HorsePlayerAccess;
import com.equestricraft.core.horse.access.HorsePlayerAccessRepository;
import com.equestricraft.core.horse.command.AbstractHorseCommand;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.mod.prompt.PlayerSearchPrompt;
import java.util.Optional;

public class HorseAccessGrantCommand
extends AbstractHorseCommand {
    private final String playerIgn;
    @Service
    private static HorsePlayerAccessRepository horsePlayerAccessRepository;
    @Service
    private static PlayerService playerService;

    public HorseAccessGrantCommand(ECPlayer player, String playerIgn) {
        super(player);
        this.playerIgn = playerIgn;
    }

    public HorseAccessGrantCommand(ECPlayer player) {
        this(player, null);
    }

    @Override
    protected Response execute() {
        Optional<ECPlayer> playerGettingAccess = this.getPlayerGettingAccess();
        if (playerGettingAccess.isEmpty()) {
            return ResponseFactory.fail();
        }
        ECPlayer playerToGrant = playerGettingAccess.get();
        HorsePermissionChecker.ensureHasPermissionLevel(this.player, this.horse, HorsePermissionLevel.OWNER);
        HorsePlayerAccess newAccess = new HorsePlayerAccess(this.horse.getId(), playerToGrant.getId(), System.currentTimeMillis());
        horsePlayerAccessRepository.add(newAccess);
        playerToGrant.notify(I18n.getLabel("horse.player-access.you-granted", this.player.getIgn(), this.horse.getName()));
        return ResponseFactory.success(I18n.getLabel("horse.player-access.granted", playerToGrant.getIgn(), this.horse.getName()));
    }

    private Optional<ECPlayer> getPlayerGettingAccess() {
        if (this.playerIgn == null) {
            return PlayerSearchPrompt.showPlayerSearchPrompt(this.player);
        }
        return Optional.ofNullable(playerService.retrievePlayerByIgn(this.playerIgn));
    }
}

