/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.access;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.access.HorsePlayerAccessKey;
import com.equestricraft.core.horse.access.HorsePlayerAccessRepository;
import com.equestricraft.core.horse.command.AbstractHorseCommand;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerService;

public class HorseAccessRevokeCommand
extends AbstractHorseCommand {
    private final String playerIgn;
    private final int playerId;
    @Service
    private static PlayerRepository playerRepository;
    @Service
    private static PlayerService playerService;
    @Service
    private static HorsePlayerAccessRepository horsePlayerAccessRepository;

    public HorseAccessRevokeCommand(ECPlayer player, String playerIgn) {
        super(player);
        this.playerIgn = playerIgn;
        this.playerId = 0;
    }

    public HorseAccessRevokeCommand(ECPlayer player, int playerId) {
        super(player);
        this.playerIgn = null;
        this.playerId = playerId;
    }

    @Override
    protected Response execute() {
        HorsePermissionChecker.ensureHasPermissionLevel(this.player, this.horse, HorsePermissionLevel.OWNER);
        ECPlayer playerGettingRevoked = this.getPlayer();
        horsePlayerAccessRepository.removeByKey(new HorsePlayerAccessKey(this.horse.getId(), this.player.getId()));
        playerGettingRevoked.notify(I18n.getLabel("horse.player-access.you-revoked", this.player.getIgn(), this.horse.getName()));
        return ResponseFactory.success(I18n.getLabel("horse.player-access.revoked", playerGettingRevoked.getIgn(), this.horse.getName()));
    }

    private ECPlayer getPlayer() {
        if (this.playerIgn == null) {
            return (ECPlayer)playerRepository.findByKey(this.playerId);
        }
        return playerService.retrievePlayerByIgn(this.playerIgn);
    }
}

