/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.access;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.access.HorsePlayerAccessPage;
import com.equestricraft.core.horse.access.HorsePlayerAccessPageService;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.horse.access.HorseAccessGrantCommand;
import com.equestricraft.mod.horse.access.HorseAccessRevokeCommand;
import com.equestricraft.mod.horse.access.HorseAccessService;
import com.equestricraft.mod.packet.ClientBoundHorsePlayerAccessScreenOpenPacket;

public class HorseAccessServiceImpl
implements HorseAccessService {
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorsePlayerAccessPageService horsePlayerAccessPageService;
    @Service
    private HorseTransformer horseTransformer;

    @Override
    public Response startPlayerHorseAccessGrant(ECPlayer playerGranting, int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Response response = horse.getCommandExecutor().execute(new HorseAccessGrantCommand(playerGranting));
        playerGranting.getMenus().showHorseMenu(horse, "PLAYER_ACCESS");
        return response;
    }

    @Override
    public Response revokeAccessFromHorse(ECPlayer playerRevoking, int horseId, int playerId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        return horse.getCommandExecutor().execute(new HorseAccessRevokeCommand(playerRevoking, playerId));
    }

    @Override
    public Response showHorseAccessMenu(ECPlayer player, int horseId, int pageNumber) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        return this.showHorseAccessMenu(player, horse, pageNumber);
    }

    @Override
    public Response showHorseAccessMenu(ECPlayer player, EQHorse horse, int pageNumber) {
        HorsePermissionChecker.ensureHasPermissionLevel(player, horse, HorsePermissionLevel.OWNER);
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        HorsePlayerAccessPage page = this.horsePlayerAccessPageService.retrieveHorsePlayerAccessPage(horse, pageNumber);
        ClientBoundHorsePlayerAccessScreenOpenPacket packet = new ClientBoundHorsePlayerAccessScreenOpenPacket(simple, page);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }
}

