/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.breeding;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.version.BuildInformation;
import com.equestricraft.core.breeding.BreedingPlayer;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.mod.client.item.BreedingTool;
import com.equestricraft.mod.horse.PlayerInteractHorseEvent;
import com.equestricraft.mod.horse.breeding.BreedingService;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class BreedingListener {
    @Service
    private static BreedingService breedingService;

    @SubscribeEvent
    public static void onBreedingToolUse(PlayerInteractHorseEvent event) {
        if (!BuildInformation.get().isDevBuild()) {
            return;
        }
        ItemStack item = event.getItemInHand();
        if (item.m_41720_() instanceof BreedingTool) {
            TaskScheduler.executeAsyncTask(() -> {
                BreedingPlayer breedingPlayer = event.getPlayer().require(BreedingPlayer.class);
                if (breedingPlayer.getProgression().hasXp(HorseSettings.getBreedingPlayerXpNeeded())) {
                    Response r = breedingService.selectHorseForBreeding(breedingPlayer, event.getHorse());
                    event.getPlayer().showResponse(r);
                } else {
                    breedingPlayer.sendMessage(I18n.getLabel("breeding.not-enough-player-xp"));
                }
            });
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(ECPlayerJoinEvent event) {
        OnlinePlayer player = event.getPlayer();
        BreedingPlayer breedingPlayer = new BreedingPlayer(player.getCorePlayer());
        player.provideData(breedingPlayer);
    }

    private BreedingListener() {
    }
}

