/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.breeding;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseBreedingAttemptResult;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.version.BuildInformation;
import com.equestricraft.core.breeding.BreedingPlayer;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptSession;
import com.equestricraft.core.horse.pregnancy.PregnancyException;
import com.equestricraft.core.horse.pregnancy.PregnancyRequest;
import com.equestricraft.core.horse.pregnancy.PregnancySession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.item.BreedingTool;
import com.equestricraft.mod.client.item.ModItems;
import com.equestricraft.mod.horse.breeding.BreedingService;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.ComponentUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BreedingServiceImpl
implements BreedingService {
    @Service
    private PregnancySession pregnancySession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseBreedingAttemptSession horseBreedingAttemptSession;

    @Override
    public Response giveToolToPlayer(OnlinePlayer player) {
        if (!BuildInformation.get().isDevBuild()) {
            return ResponseFactory.fail();
        }
        if (!player.getProgression().hasXp(HorseSettings.getBreedingPlayerXpNeeded())) {
            return ResponseFactory.fail(I18n.getLabel("breeding.not-enough-player-xp"));
        }
        BreedingTool breedingTool = ModItems.getBreedingTool();
        ItemStack tool = new ItemStack((ItemLike)breedingTool);
        tool.m_41714_((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("breeding.tool.name")));
        player.serverPlayer().m_150109_().m_36054_(tool);
        return ResponseFactory.success(I18n.getLabel("breeding.tool.give-message"));
    }

    @Override
    public Response selectHorseForBreeding(BreedingPlayer player, EQHorse horse) {
        if (horse.getHorseGender() == HorseGender.STALLION) {
            player.setSelectedStallion(horse);
        } else if (horse.getHorseGender() == HorseGender.MARE) {
            player.setSelectedMare(horse);
        } else {
            return ResponseFactory.fail(I18n.getLabel("breeding.invalid-gender.message"));
        }
        if (player.getSelectedStallion() != null && player.getSelectedMare() != null) {
            PregnancyRequest pregnancyRequest = new PregnancyRequest(player.getSelectedMare().getId(), player.getSelectedStallion().getId(), player);
            try {
                this.pregnancySession.addNewPregnancy(pregnancyRequest);
                player.clearSelection();
                return ResponseFactory.success(I18n.getLabel("breeding.success"));
            }
            catch (PregnancyException ex) {
                return ResponseFactory.fail(ex);
            }
        }
        return ResponseFactory.success(I18n.getLabel("breeding.horse-selected.message", horse.getHorseGender().opposite().getTranslatedName()));
    }

    @Override
    public Response cancelSelection(ECPlayer player) {
        if (!BuildInformation.get().isDevBuild()) {
            return ResponseFactory.fail();
        }
        BreedingPlayer breedingPlayer = player.require(BreedingPlayer.class);
        breedingPlayer.clearSelection();
        return ResponseFactory.success(I18n.getLabel("breeding.cancelled"));
    }

    @Override
    public void naturallyBreedHorses(EntityHorse mareEntity, EntityHorse stallionEntity) {
        EQHorse mare = (EQHorse)this.horseRepository.findByKey(mareEntity.getInternalId());
        EQHorse stallion = (EQHorse)this.horseRepository.findByKey(stallionEntity.getInternalId());
        PregnancyRequest pregnancyRequest = new PregnancyRequest(mareEntity.getInternalId(), stallionEntity.getInternalId(), mare.getOwner());
        try {
            this.horseBreedingAttemptSession.setBreedingAttemptForHorseOnHorse(stallion, mare, HorseBreedingAttemptResult.ACCEPTED);
            this.pregnancySession.addNewPregnancy(pregnancyRequest);
        }
        catch (PregnancyException pregnancyException) {
            // empty catch block
        }
    }

    @Override
    public void rejectBreeding(EntityHorse mareEntity, EntityHorse stallionEntity) {
        EQHorse mare = (EQHorse)this.horseRepository.findByKey(mareEntity.getInternalId());
        EQHorse stallion = (EQHorse)this.horseRepository.findByKey(stallionEntity.getInternalId());
        this.horseBreedingAttemptSession.setBreedingAttemptForHorseOnHorse(stallion, mare, HorseBreedingAttemptResult.REJECTED);
    }
}

