/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.breeding;

import com.equestricraft.common.HorseGender;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.stress.HorseStressProvider;
import java.time.Duration;

public class HorseBreedingStressProvider
implements HorseStressProvider {
    @Override
    public float getStressPercentage(EQHorse horse) {
        if (horse.getHorseGender() == HorseGender.MARE) {
            int attempts = horse.getBreeding().getTotalBreedingAttempts();
            if (attempts == 0) {
                return 0.0f;
            }
            Duration durationSince = horse.getBreeding().getDurationSinceHorseLastHadBreedingAttempt().orElseThrow();
            if (durationSince.toDays() <= 1L) {
                float stressIncreaseFactor = (float)attempts / 10.0f;
                return (1.0f - Math.max(stressIncreaseFactor, 1.0f)) / 3.0f;
            }
        }
        return 0.0f;
    }
}

