/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.breeding;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.HorseBreedingAttemptResult;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.pregnancy.PregnancySettings;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import com.equestricraft.mod.horse.breeding.HorseNaturalBreedAcceptEvent;
import com.equestricraft.mod.horse.breeding.HorseNaturalBreedRejectEvent;
import java.time.Duration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MareAcceptMateGoal
extends AbstractHorseGoal {
    private EntityHorse possibleMate = null;
    private CurrentMate currentMate = null;
    private float acceptProbability = 0.0f;
    private static final double MATE_CONTINUE_DISTANCE = 2.5;
    private static final long MATE_DURATION_SECONDS = 5L;

    public MareAcceptMateGoal(EntityHorse horse) {
        super(horse);
    }

    public void setPossibleMate(EntityHorse possibleMate) {
        this.possibleMate = possibleMate;
    }

    @Override
    public boolean shouldRun() {
        return FeatureFlag.BREEDING.isEnabled() && this.isHorseValid() && this.possibleMate != null && !this.entityHorse.m_20160_();
    }

    private boolean isHorseValid() {
        return this.entityHorse.getHorseEntityType() == HorseEntityType.STANDARD && this.entityHorse.getGender() == HorseGender.MARE;
    }

    @Override
    public void startGoal() {
        this.acceptProbability = this.determineAcceptProbability();
    }

    private float determineAcceptProbability() {
        EQHorse horseData = this.entityHorse.getHorseData();
        float memory = horseData.getMemory().getValue();
        Duration duration = Duration.ofDays((long)(memory * (float)PregnancySettings.getMareAcceptMateMaximumMemoryDays().intValue()));
        int acceptCount = horseData.getBreeding().getBreedingAttemptsInPastDuration(HorseBreedingAttemptResult.ACCEPTED, duration);
        int rejectCount = horseData.getBreeding().getBreedingAttemptsInPastDuration(HorseBreedingAttemptResult.REJECTED, duration);
        float intelligence = horseData.getIntelligence().getValue();
        if (intelligence > PregnancySettings.getMareAcceptMateIntelligenceThreshold().floatValue()) {
            if (acceptCount == 0) {
                return 0.4f;
            }
            int factor = rejectCount / acceptCount;
            return (float)factor * 0.4f;
        }
        int count = acceptCount + rejectCount;
        float chance = 1.0f - (float)count / 10.0f;
        chance = NumberUtils.keepWithinRange(Float.valueOf(chance), Float.valueOf(0.0f), Float.valueOf(1.0f)).floatValue();
        return chance * 0.5f;
    }

    @Override
    public void tickGoal() {
        if (this.currentMate == null) {
            if (this.entityHorse.m_21187_().nextFloat() < this.acceptProbability) {
                this.currentMate = new CurrentMate(this.possibleMate, System.currentTimeMillis());
            } else {
                HorseNaturalBreedRejectEvent rejectEvent = new HorseNaturalBreedRejectEvent(this.entityHorse, this.possibleMate);
                TaskScheduler.executeAsyncTask(() -> MinecraftForge.EVENT_BUS.post((Event)rejectEvent));
            }
        } else {
            Duration durationTogether = DateUtils.durationSince(this.currentMate.startTime());
            if (durationTogether.toSeconds() > 5L) {
                this.currentMate.mate().setTargetForBreeding(null);
                HorseNaturalBreedAcceptEvent completeEvent = new HorseNaturalBreedAcceptEvent(this.entityHorse, this.currentMate.mate());
                this.currentMate = null;
                TaskScheduler.executeAsyncTask(() -> MinecraftForge.EVENT_BUS.post((Event)completeEvent));
            } else {
                double distance = this.entityHorse.m_20182_().m_82554_(this.currentMate.mate().m_20182_());
                if (distance >= 2.5) {
                    this.currentMate = null;
                }
            }
        }
    }

    private record CurrentMate(EntityHorse mate, long startTime) {
    }
}

