/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.breeding;

import com.equestricraft.common.HorseGender;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.pregnancy.PregnancySettings;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.horse.AbstractHorseGoal;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class StallionFindMateGoal
extends AbstractHorseGoal {
    public StallionFindMateGoal(EntityHorse horse) {
        super(horse);
    }

    @Override
    public boolean shouldRun() {
        return FeatureFlag.BREEDING.isEnabled() && this.isHorseValid() && this.entityHorse.getTargetForBreeding() == null && !this.entityHorse.m_20160_() && this.canOwnerUseBreeding(this.entityHorse) && this.entityHorse.m_21187_().nextFloat() < PregnancySettings.getStallionFindMateProbabilityPerTick().floatValue();
    }

    @Override
    public boolean shouldContinueToUse() {
        return this.entityHorse.getTargetForBreeding() == null && !this.entityHorse.m_20160_();
    }

    private boolean canOwnerUseBreeding(EntityHorse horse) {
        return horse.getHorseData().getOwner().getProgression().hasXp(HorseSettings.getBreedingPlayerXpNeeded());
    }

    private boolean isHorseValid() {
        return this.entityHorse.getHorseEntityType() == HorseEntityType.STANDARD && this.entityHorse.getGender() == HorseGender.STALLION;
    }

    @Override
    public void startGoal() {
        List<EntityHorse> nearbyHorses = this.entityHorse.f_19853_.m_45971_(EntityHorse.class, TargetingConditions.m_148353_(), (LivingEntity)this.entityHorse, new AABB(this.entityHorse.m_142538_()).m_82400_(this.determineSearchDistance()));
        nearbyHorses = nearbyHorses.stream().filter(h -> h.getHorseEntityType() == HorseEntityType.STANDARD).filter(h -> h.getGender() == HorseGender.MARE).filter(this::canOwnerUseBreeding).filter(this::isAttractedTo).toList();
        for (int i = 0; i < Math.min(nearbyHorses.size(), this.determineMaximumHorsesToTry()); ++i) {
            EntityHorse h2 = nearbyHorses.get(i);
            Path path = this.entityHorse.m_21573_().m_6570_((Entity)h2, 1);
            if (path == null || !path.m_77403_() || this.hasAttemptedOnHorseTooRecently(h2)) continue;
            this.entityHorse.setTargetForBreeding(h2);
            return;
        }
    }

    private double determineSearchDistance() {
        float intelligence = this.entityHorse.getHorseData().getIntelligence().getValue();
        float distanceIncrease = intelligence * 10.0f;
        return 5.0 + (double)distanceIncrease;
    }

    private int determineMaximumHorsesToTry() {
        float intelligence = this.entityHorse.getHorseData().getIntelligence().getValue();
        return (int)(intelligence * 5.0f);
    }

    private boolean hasAttemptedOnHorseTooRecently(EntityHorse nearestHorse) {
        Optional<Duration> durationSinceLastAttempt;
        if (!this.entityHorse.getHorseData().getMemory().test()) {
            return false;
        }
        EQHorse horseData = this.entityHorse.getHorseData();
        EQHorse nearestHorseData = nearestHorse.getHorseData();
        if (horseData != null && nearestHorseData != null && (durationSinceLastAttempt = horseData.getBreeding().getDurationSinceLastBreedingAttemptOnHorse(nearestHorseData)).isPresent()) {
            int minutes = (int)durationSinceLastAttempt.get().toMinutes();
            return minutes < HorseSettings.getBreedingAttemptCoolDownMinutes();
        }
        return false;
    }

    private boolean isAttractedTo(EntityHorse mareEntity) {
        float stallionIntelligence = this.entityHorse.getHorseData().getIntelligence().getValue();
        if (stallionIntelligence < 0.2f) {
            return true;
        }
        float corValue = this.entityHorse.getHorseData().getLineage().getCoefficientOfRelationshipWith(mareEntity.getHorseData());
        return (double)corValue <= 0.2;
    }
}

