/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.cache;

import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.util.ChunkPosUtil;
import net.minecraft.world.level.ChunkPos;

public final class HorseCacheEntry {
    private final int id;
    private final EQHorse horse;
    private EntityHorse entity;
    private ECLevel level;
    private ChunkPos chunkPos;

    HorseCacheEntry(EQHorse horse) {
        this.id = horse.getId();
        this.entity = null;
        this.horse = horse;
        DirectionalCoordinate location = horse.getDirectionalCoordinate();
        this.level = ECLevel.getByIdentifier(location.world());
        this.chunkPos = ChunkPosUtil.toChunkPos(location);
    }

    public int getId() {
        return this.id;
    }

    public EQHorse getHorse() {
        return this.horse;
    }

    public EntityHorse getEntity() {
        return this.entity;
    }

    public void setEntity(EntityHorse entity) {
        this.entity = entity;
    }

    public ECLevel getLevel() {
        return this.level;
    }

    public void setLevel(ECLevel level) {
        this.level = level;
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public void setChunkPos(ChunkPos chunkPos) {
        this.chunkPos = chunkPos;
    }

    public boolean active() {
        return this.entity != null;
    }

    public void removeEntity() {
        this.entity = null;
    }

    public void clearEntityData() {
        this.removeEntity();
        this.level = null;
        this.chunkPos = null;
    }
}

