/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.cache;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.cache.HorseCacheEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.world.level.ChunkPos;

public final class HorseEntityCache {
    private static final HorseEntityCache instance = new HorseEntityCache();
    private final DataStructure dataStructure = new DataStructure();
    private final StampedLock lock = new StampedLock();
    private boolean initialized = false;
    @Service
    private static HorseRepository horseRepository;

    public static HorseEntityCache getInstance() {
        return instance;
    }

    private HorseEntityCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initializeCache() {
        if (this.initialized) {
            return;
        }
        long stamp = this.lock.writeLock();
        try {
            List<EQHorse> livingHorses = horseRepository.findAllLivingHorses();
            for (EQHorse horse : livingHorses) {
                DirectionalCoordinate location = horse.getDirectionalCoordinate();
                if (location == null) continue;
                this.dataStructure.addHorse(new HorseCacheEntry(horse));
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityForHorse(EntityHorse entity) {
        if (entity.getHorseData() == null) {
            return;
        }
        long stamp = this.lock.writeLock();
        try {
            this.dataStructure.findById(entity.getInternalId()).ifPresent(e -> e.setEntity(entity));
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocation(EQHorse horse, ECLevel level, ChunkPos pos) {
        long stamp = this.lock.writeLock();
        try {
            Optional<HorseCacheEntry> entry = this.dataStructure.findById(horse.getId());
            if (entry.isPresent()) {
                HorseCacheEntry e = entry.get();
                e.setLevel(level);
                e.setChunkPos(pos);
            } else {
                HorseCacheEntry e = new HorseCacheEntry(horse);
                this.dataStructure.addHorse(e);
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHorseActive(int id) {
        long stamp = this.lock.readLock();
        try {
            Optional<HorseCacheEntry> horse = this.dataStructure.findById(id);
            boolean bl = horse.filter(HorseCacheEntry::active).isPresent();
            return bl;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<HorseCacheEntry> getEntityForHorse(int id) {
        long stamp = this.lock.readLock();
        try {
            Optional<HorseCacheEntry> optional = this.dataStructure.findById(id);
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EQHorse> getActiveHorses() {
        long stamp = this.lock.readLock();
        try {
            List<EQHorse> list = this.dataStructure.findAllActive().stream().map(HorseCacheEntry::getHorse).toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EQHorse> getHorsesInDimensionChunk(ECLevel level, ChunkPos chunkPos) {
        long stamp = this.lock.readLock();
        try {
            List<EQHorse> list = this.dataStructure.findAllInDimensionChunk(level, chunkPos).stream().map(HorseCacheEntry::getHorse).toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHorse(EQHorse horse) {
        long stamp = this.lock.writeLock();
        try {
            this.dataStructure.removeHorse(horse.getId());
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocationDataForHorse(int id) {
        long stamp = this.lock.writeLock();
        try {
            Optional<HorseCacheEntry> horse = this.dataStructure.findById(id);
            horse.ifPresent(HorseCacheEntry::clearEntityData);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntityForHorse(int id) {
        long stamp = this.lock.writeLock();
        try {
            Optional<HorseCacheEntry> h = this.dataStructure.findById(id);
            h.ifPresent(HorseCacheEntry::removeEntity);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private static class DataStructure {
        private final List<HorseCacheEntry> entries = new ArrayList<HorseCacheEntry>(0);
        private final Map<Integer, HorseCacheEntry> idMap = new HashMap<Integer, HorseCacheEntry>();

        private DataStructure() {
        }

        public void addHorse(HorseCacheEntry horse) {
            this.entries.add(horse);
            this.idMap.put(horse.getId(), horse);
        }

        public Optional<HorseCacheEntry> findById(int id) {
            return Optional.ofNullable(this.idMap.get(id));
        }

        public List<HorseCacheEntry> findAllActive() {
            return this.entries.stream().filter(HorseCacheEntry::active).toList();
        }

        public List<HorseCacheEntry> findAllInDimensionChunk(ECLevel level, ChunkPos chunkPos) {
            return this.entries.stream().filter(e -> e.getLevel() != null && e.getLevel() == level).filter(e -> e.getChunkPos() != null && e.getChunkPos() == chunkPos).toList();
        }

        public void removeHorse(int id) {
            this.entries.removeIf(h -> h.getId() == id);
            this.idMap.remove(id);
        }
    }
}

